/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.loot.global;

import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import hellfirepvp.astralsorcery.common.util.loot.LootUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class LootModifierScorchingHeat
extends LootModifier {
    private LootModifierScorchingHeat(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!LootUtil.doesContextFulfillSet(context, LootParameterSets.field_216267_h)) {
            return generatedLoot;
        }
        return generatedLoot.stream().filter(stack -> !stack.func_190926_b()).map(stack -> {
            Entity e;
            Optional<ItemStack> furnaceResult = RecipeHelper.findSmeltingResult((World)context.func_202879_g(), stack);
            if (context.func_216033_a(LootParameters.field_216281_a) && (e = (Entity)context.func_216031_c(LootParameters.field_216281_a)) instanceof PlayerEntity) {
                furnaceResult.ifPresent(result -> BasicEventHooks.firePlayerSmeltedEvent((PlayerEntity)((PlayerEntity)e), (ItemStack)result));
            }
            furnaceResult.ifPresent(result -> {
                int fortuneLevel;
                ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
                if (!tool.func_190926_b() && !(result.func_77973_b() instanceof BlockItem) && (fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool)) > 0) {
                    int addedCount = context.func_216032_b().nextInt(fortuneLevel + 2) - 1;
                    if (addedCount < 0) {
                        addedCount = 0;
                    }
                    result.func_190920_e(result.func_190916_E() * (addedCount + 1));
                }
            });
            return furnaceResult.orElse((ItemStack)stack);
        }).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<LootModifierScorchingHeat> {
        public LootModifierScorchingHeat read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new LootModifierScorchingHeat(lootConditions);
        }

        public JsonObject write(LootModifierScorchingHeat instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

