/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.block.tile.BlockFlareLight;
import hellfirepvp.astralsorcery.common.block.tile.BlockTranslucentBlock;
import hellfirepvp.astralsorcery.common.item.base.AlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.base.client.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.tile.TileIlluminator;
import hellfirepvp.astralsorcery.common.tile.TileTranslucentBlock;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ItemIlluminationWand
extends Item
implements ItemDynamicColor,
AlignmentChargeConsumer {
    private static final float COST_PER_ILLUMINATION = 650.0f;
    private static final float COST_PER_FLARE = 300.0f;

    public ItemIlluminationWand() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        DyeColor color = ItemIlluminationWand.getConfiguredColor(stack);
        tooltip.add((ITextComponent)ColorUtils.getTranslation(color).func_240699_a_(ColorUtils.textFormattingForDye(color)));
    }

    @Override
    public float getAlignmentChargeCost(PlayerEntity player, ItemStack stack) {
        if (player.func_225608_bj_()) {
            return 650.0f;
        }
        return 300.0f;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        Direction dir = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (world.func_201670_d() || player == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemIlluminationWand)) {
            return ActionResultType.SUCCESS;
        }
        BlockState state = world.func_180495_p(pos);
        if (player.func_225608_bj_()) {
            if (state.func_177230_c() instanceof BlockTranslucentBlock) {
                TileTranslucentBlock tb = MiscUtils.getTileAt((IBlockReader)world, pos, TileTranslucentBlock.class, true);
                if (tb != null && (tb.getPlayerUUID() == null || tb.getPlayerUUID().equals(player.func_110124_au())) && tb.revert()) {
                    SoundHelper.playSoundAround((SoundEvent)SoundsAS.ILLUMINATION_WAND_UNHIGHLIGHT, SoundCategory.BLOCKS, world, (Vector3i)pos, 0.6f, 0.9f + field_77697_d.nextFloat() * 0.2f);
                }
            } else {
                TileEntity tile = MiscUtils.getTileAt((IBlockReader)world, pos, TileEntity.class, true);
                if (tile == null && !state.hasTileEntity() && player.func_175151_a(pos, dir, stack) && VoxelShapes.func_197868_b().equals(world.func_180495_p(pos).func_196954_c((IBlockReader)world, pos)) && AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, 650.0f, false) && world.func_180501_a(pos, BlocksAS.TRANSLUCENT_BLOCK.func_176223_P(), 11)) {
                    SoundHelper.playSoundAround((SoundEvent)SoundsAS.ILLUMINATION_WAND_HIGHLIGHT, SoundCategory.BLOCKS, world, (Vector3i)pos, 0.6f, 0.9f + field_77697_d.nextFloat() * 0.2f);
                    TileTranslucentBlock tb = MiscUtils.getTileAt((IBlockReader)world, pos, TileTranslucentBlock.class, true);
                    if (tb != null) {
                        tb.setFakedState(state);
                        tb.setOverlayColor(ColorUtils.flareColorFromDye(ItemIlluminationWand.getConfiguredColor(stack)));
                        tb.setPlayerUUID(player.func_110124_au());
                    } else {
                        world.func_180501_a(pos, state, 11);
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        TileIlluminator illum = MiscUtils.getTileAt((IBlockReader)world, pos, TileIlluminator.class, true);
        if (illum != null) {
            illum.onWandUsed(stack);
            SoundHelper.playSoundAround((SoundEvent)SoundsAS.ILLUMINATION_WAND_LIGHT, SoundCategory.BLOCKS, world, (Vector3i)pos, 0.6f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        ISelectionContext selContext = ISelectionContext.func_216374_a((Entity)player);
        BlockPos placePos = pos;
        BlockState placeState = ItemIlluminationWand.getPlacingState(stack);
        if (!BlockUtils.isReplaceable(world, pos)) {
            placePos = placePos.func_177972_a(dir);
        }
        if (!BlockUtils.isReplaceable(world, placePos)) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175151_a(placePos, dir, stack)) {
            if (world.func_180495_p(placePos).equals(placeState)) {
                if (world.func_180501_a(placePos, Blocks.field_150350_a.func_176223_P(), 11)) {
                    SoundHelper.playSoundAround((SoundEvent)SoundsAS.ILLUMINATION_WAND_LIGHT, SoundCategory.BLOCKS, world, (Vector3i)pos, 0.6f, 1.0f);
                }
            } else if (placeState.func_196955_c((IWorldReader)world, placePos) && world.func_226663_a_(placeState, placePos, selContext) && AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, 300.0f, false) && world.func_180501_a(placePos, placeState, 11)) {
                SoundHelper.playSoundAround((SoundEvent)SoundsAS.ILLUMINATION_WAND_LIGHT, SoundCategory.BLOCKS, world, (Vector3i)pos, 0.6f, 1.0f);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return -1;
        }
        DyeColor color = ItemIlluminationWand.getConfiguredColor(stack);
        return ColorUtils.flareColorFromDye(color).getRGB() | 0xFF000000;
    }

    public static void setConfiguredColor(ItemStack stack, DyeColor color) {
        NBTHelper.getPersistentData(stack).func_74768_a("color", color != null ? color.func_196059_a() : DyeColor.YELLOW.func_196059_a());
    }

    @Nonnull
    public static DyeColor getConfiguredColor(ItemStack stack) {
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        if (tag.func_74764_b("color")) {
            return DyeColor.func_196056_a((int)tag.func_74762_e("color"));
        }
        return DyeColor.YELLOW;
    }

    @Nonnull
    public static BlockState getPlacingState(ItemStack wand) {
        return (BlockState)BlocksAS.FLARE_LIGHT.func_176223_P().func_206870_a(BlockFlareLight.COLOR, (Comparable)ItemIlluminationWand.getConfiguredColor(wand));
    }
}

