/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import com.google.common.collect.Iterables;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.item.base.AlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktShootEntity;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ItemBlinkWand
extends Item
implements AlignmentChargeConsumer {
    private static final float COST_PER_BLINK = 700.0f;
    private static final float COST_PER_DASH = 850.0f;

    public ItemBlinkWand() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)ItemBlinkWand.getBlinkMode(stack).getDisplay().func_240699_a_(TextFormatting.GOLD));
    }

    @Override
    public float getAlignmentChargeCost(PlayerEntity player, ItemStack stack) {
        ItemStack held;
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return 0.0f;
        }
        if (ItemBlinkWand.getBlinkMode(stack) == BlinkMode.TELEPORT) {
            return 700.0f;
        }
        if (player.func_184587_cr() && !(held = player.func_184607_cu()).func_190926_b() && held.func_77973_b() instanceof ItemBlinkWand) {
            int timeLeft = player.func_184605_cv();
            float strength = 0.2f + Math.min(1.0f, (float)Math.min(50, stack.func_77988_m() - timeLeft) / 50.0f) * 0.8f;
            return 850.0f * strength;
        }
        return 0.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            BlinkMode nextMode = ItemBlinkWand.getBlinkMode(held).next();
            ItemBlinkWand.setBlinkMode(held, nextMode);
            player.func_146105_b((ITextComponent)nextMode.getDisplay(), true);
        } else if (!player.func_184811_cZ().func_185141_a((Item)this)) {
            player.func_184598_c(hand);
        }
        return ActionResult.func_226249_b_((Object)held);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        float chargeCost;
        float strength;
        if (worldIn.func_201670_d() || !(entityLiving instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entityLiving;
        BlinkMode mode = ItemBlinkWand.getBlinkMode(stack);
        if (mode == BlinkMode.TELEPORT) {
            BlockPos at;
            Vector3 origin = Vector3.atEntityCorner((Entity)player).addY(0.5);
            Vector3 look = new Vector3(player.func_70676_i(1.0f)).normalize().multiply(40.0f).add(origin);
            ArrayList blockLine = new ArrayList();
            RaytraceAssist rta = new RaytraceAssist(origin, look);
            rta.forEachBlockPos(pos -> MiscUtils.executeWithChunk((IWorldReader)player.func_130014_f_(), pos, () -> {
                if (BlockUtils.isReplaceable(player.func_130014_f_(), pos) && BlockUtils.isReplaceable(player.func_130014_f_(), pos.func_177984_a())) {
                    blockLine.add(pos);
                    return true;
                }
                return false;
            }, false));
            if (!blockLine.isEmpty() && origin.distance((Vector3i)(at = (BlockPos)Iterables.getLast(blockLine))) > 5.0 && AlignmentChargeHandler.INSTANCE.drainCharge((PlayerEntity)player, LogicalSide.SERVER, 700.0f, false)) {
                player.func_70634_a((double)at.func_177958_n() + 0.5, (double)at.func_177956_o(), (double)at.func_177952_p() + 0.5);
                if (!player.func_184812_l_()) {
                    player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 40);
                }
            }
        } else if (mode == BlinkMode.LAUNCH && (strength = 0.2f + Math.min(1.0f, (float)Math.min(50, stack.func_77988_m() - timeLeft) / 50.0f) * 0.8f) > 0.3f && AlignmentChargeHandler.INSTANCE.drainCharge((PlayerEntity)player, LogicalSide.SERVER, chargeCost = 850.0f * strength, false)) {
            Vector3 motion = new Vector3(player.func_70676_i(1.0f)).normalize().multiply(strength * 3.0f);
            if (motion.getY() > 0.0) {
                motion.setY(MathHelper.func_151237_a((double)(motion.getY() + (double)(0.7f * strength)), (double)(0.7f * strength), (double)3.4028234663852886E38));
            }
            player.func_213317_d(motion.toVector3d());
            player.field_70143_R = 0.0f;
            if (ItemMantle.getEffect((LivingEntity)player, (IWeakConstellation)ConstellationsAS.vicio) != null) {
                AstralSorcery.getProxy().scheduleClientside(() -> ((ServerPlayerEntity)player).func_226567_ej_(), 2);
            }
            PktShootEntity pkt = new PktShootEntity(player.func_145782_y(), motion);
            pkt.setEffectLength(strength);
            PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos(worldIn, (Vector3i)player.func_233580_cy_(), 64.0));
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (entity.func_130014_f_().func_201670_d()) {
            float perc = 0.2f + Math.min(1.0f, (float)Math.min(50, stack.func_77988_m() - count) / 50.0f) * 0.8f;
            this.playUseParticles(stack, entity, count, perc);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playUseParticles(ItemStack stack, LivingEntity entity, int useTicks, float usagePercent) {
        block9: {
            block8: {
                if (!(entity instanceof PlayerEntity)) {
                    return;
                }
                PlayerEntity player = (PlayerEntity)entity;
                if (player.func_184811_cZ().func_185141_a((Item)this)) {
                    return;
                }
                if (ItemBlinkWand.getBlinkMode(stack) != BlinkMode.LAUNCH) break block8;
                Vector3 look = new Vector3(entity.func_70676_i(1.0f)).normalize().multiply(20);
                Vector3 pos = Vector3.atEntityCorner((Entity)entity).addY(entity.func_70047_e());
                Vector3 motion = look.clone().normalize().multiply(-0.8f + field_77697_d.nextFloat() * -0.5f);
                Vector3 perp = look.clone().perpendicular().normalize();
                for (int i = 0; i < Math.round(usagePercent * 6.0f); ++i) {
                    float dst = i == 0 ? field_77697_d.nextFloat() * 0.4f : 0.2f + field_77697_d.nextFloat() * 0.4f;
                    float speed = i == 0 ? 0.005f : 0.5f + field_77697_d.nextFloat() * 0.5f;
                    float angleDeg = field_77697_d.nextFloat() * 360.0f;
                    Vector3 angle = perp.clone().rotate(angleDeg, look).normalize();
                    Vector3 at = pos.clone().add(look.clone().multiply(0.7f + field_77697_d.nextFloat() * 0.3f)).add(angle.clone().multiply(dst));
                    Vector3 mot = motion.clone().add(angle.clone().multiply(0.1f + field_77697_d.nextFloat() * 0.15f)).multiply(speed);
                    FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).setOwner(entity.func_110124_au())).spawn(at)).setScaleMultiplier(0.3f + field_77697_d.nextFloat() * 0.3f)).setAlphaMultiplier(usagePercent)).setMotion(mot)).color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_VICIO))).setMaxAge(20 + field_77697_d.nextInt(15));
                    if (!field_77697_d.nextBoolean()) continue;
                    p.color(VFXColorFunction.WHITE);
                }
                break block9;
            }
            if (ItemBlinkWand.getBlinkMode(stack) != BlinkMode.TELEPORT) break block9;
            Vector3 origin = Vector3.atEntityCorner((Entity)entity).addY(0.5);
            Vector3 look = new Vector3(entity.func_70676_i(1.0f)).normalize().multiply(40.0f).add(origin);
            ArrayList line = new ArrayList();
            RaytraceAssist rta = new RaytraceAssist(origin, look);
            boolean clearLine = rta.forEachStep(v -> {
                BlockPos pos = v.toBlockPos();
                return MiscUtils.executeWithChunk((IWorldReader)entity.func_130014_f_(), pos, () -> {
                    if (BlockUtils.isReplaceable(entity.func_130014_f_(), pos) && BlockUtils.isReplaceable(entity.func_130014_f_(), pos.func_177984_a())) {
                        line.add(v);
                        return true;
                    }
                    return false;
                }, false);
            });
            if (!line.isEmpty()) {
                Vector3 last = (Vector3)Iterables.getLast(line);
                for (Vector3 v2 : line) {
                    if (v2 != last && field_77697_d.nextInt(300) != 0) continue;
                    VFXColorFunction<Object> colorFn = VFXColorFunction.constant(ColorsAS.CONSTELLATION_VICIO);
                    float scale = 0.4f + field_77697_d.nextFloat() * 0.2f;
                    float speed = field_77697_d.nextFloat() * 0.02f;
                    int age = 20 + field_77697_d.nextInt(15);
                    if (field_77697_d.nextInt(3) == 0) {
                        colorFn = VFXColorFunction.WHITE;
                    }
                    if (v2 == last) {
                        scale *= 1.5f;
                        speed *= 4.0f;
                        age = (int)((float)age * 0.7f);
                        colorFn = !clearLine ? VFXColorFunction.constant(ColorsAS.CONSTELLATION_AEVITAS) : VFXColorFunction.constant(ColorsAS.CONSTELLATION_EVORSIO);
                        if (field_77697_d.nextInt(5) == 0) {
                            colorFn = VFXColorFunction.WHITE;
                        }
                    }
                    ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).setOwner(entity.func_110124_au())).spawn(v2)).setScaleMultiplier(scale)).setAlphaMultiplier(usagePercent)).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(Vector3.random().normalize().multiply(speed))).color(colorFn)).setMaxAge(age);
                }
            }
        }
    }

    public static void setBlinkMode(@Nonnull ItemStack stack, @Nonnull BlinkMode mode) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlinkWand)) {
            return;
        }
        CompoundNBT nbt = NBTHelper.getPersistentData(stack);
        nbt.func_74768_a("blinkMode", mode.ordinal());
    }

    @Nonnull
    public static BlinkMode getBlinkMode(@Nonnull ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlinkWand)) {
            return BlinkMode.LAUNCH;
        }
        CompoundNBT nbt = NBTHelper.getPersistentData(stack);
        return MiscUtils.getEnumEntry(BlinkMode.class, nbt.func_74762_e("blinkMode"));
    }

    public static enum BlinkMode {
        LAUNCH("launch"),
        TELEPORT("teleport");

        private final String name;

        private BlinkMode(String name) {
            this.name = name;
        }

        public IFormattableTextComponent getName() {
            return new TranslationTextComponent("astralsorcery.misc.blink.mode." + this.name);
        }

        public IFormattableTextComponent getDisplay() {
            return new TranslationTextComponent("astralsorcery.misc.blink.mode", new Object[]{this.getName()});
        }

        @Nonnull
        private BlinkMode next() {
            int next = (this.ordinal() + 1) % BlinkMode.values().length;
            return MiscUtils.getEnumEntry(BlinkMode.class, next);
        }
    }
}

