/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingOverlayUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.item.base.AlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.base.ItemBlockStorage;
import hellfirepvp.astralsorcery.common.item.base.client.ItemHeldRender;
import hellfirepvp.astralsorcery.common.item.base.client.ItemOverlayRender;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.block.BlockGeometry;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.observerlib.client.util.BufferDecoratorBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ItemArchitectWand
extends Item
implements ItemBlockStorage,
ItemOverlayRender,
ItemHeldRender,
AlignmentChargeConsumer {
    private static final float COST_PER_PLACEMENT = 8.0f;

    public ItemArchitectWand() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)ItemArchitectWand.getPlaceMode(stack).getDisplay().func_240699_a_(TextFormatting.GOLD));
    }

    @Override
    public float getAlignmentChargeCost(PlayerEntity player, ItemStack stack) {
        PlaceMode mode = ItemArchitectWand.getPlaceMode(stack);
        return (float)this.getPlayerPlaceableStates(player, stack).size() * 8.0f * mode.getPlaceCostMulitplier();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderInHand(ItemStack stack, MatrixStack renderStack, float pTicks) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Map<BlockPos, BlockState> placeStates = this.getPlayerPlaceableStates((PlayerEntity)player, stack);
        if (placeStates.isEmpty()) {
            return true;
        }
        RenderSystem.enableTexture();
        BlockAtlasTexture.getInstance().bindTexture();
        int[] fullBright = new int[]{15, 15};
        BufferDecoratorBuilder decorator = BufferDecoratorBuilder.withLightmap((skyLight, blockLight) -> fullBright);
        Vector3 offset = RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks);
        RenderSystem.enableBlend();
        Blending.ADDITIVEDARK.apply();
        RenderSystem.disableDepthTest();
        RenderSystem.disableAlphaTest();
        RenderingUtils.draw(7, DefaultVertexFormats.field_176600_a, buf -> placeStates.forEach((pos, state) -> {
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)pos.func_177958_n() - offset.getX() + (double)0.1f, (double)pos.func_177956_o() - offset.getY() + (double)0.1f, (double)pos.func_177952_p() - offset.getZ() + (double)0.1f);
            renderStack.func_227862_a_(0.8f, 0.8f, 0.8f);
            RenderingUtils.renderSimpleBlockModel(state, renderStack, (IVertexBuilder)decorator.decorate(buf), pos, null, false);
            renderStack.func_227865_b_();
        }));
        RenderSystem.enableAlphaTest();
        RenderSystem.enableDepthTest();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderOverlay(MatrixStack renderStack, ItemStack stack, float pTicks) {
        List<Tuple<ItemStack, Integer>> foundStacks = ItemBlockStorage.getInventoryMatchingItemStacks((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack);
        RenderingOverlayUtils.renderDefaultItemDisplay(renderStack, foundStacks);
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        ItemStack held = player.func_184586_b(context.func_221531_n());
        BlockPos pos = context.func_195995_a();
        if (world.func_201670_d() || !(player instanceof ServerPlayerEntity) || held.func_190926_b()) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_()) {
            ItemBlockStorage.storeBlockState(held, world, pos);
            return ActionResultType.SUCCESS;
        }
        return this.attemptPlaceBlocks(world, player, held).func_188397_a();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        PlaceMode mode = ItemArchitectWand.getPlaceMode(held);
        if (player.func_225608_bj_()) {
            PlaceMode nextMode = mode.next();
            ItemArchitectWand.setPlaceMode(held, nextMode);
            player.func_146105_b((ITextComponent)nextMode.getDisplay(), true);
            return ActionResult.func_226248_a_((Object)held);
        }
        if (world.func_201670_d()) {
            return ActionResult.func_226248_a_((Object)held);
        }
        return this.attemptPlaceBlocks(world, player, held);
    }

    private ActionResult<ItemStack> attemptPlaceBlocks(World world, PlayerEntity player, ItemStack held) {
        Map<BlockPos, BlockState> placeStates = this.getPlayerPlaceableStates(player, held);
        if (placeStates.isEmpty()) {
            return ActionResult.func_226251_d_((Object)held);
        }
        Map<BlockState, Tuple> availableStacks = MapStream.of(ItemBlockStorage.getInventoryMatching(player, held)).filter((Predicate<Tuple<BlockState, Tuple<ItemStack, Integer>>>)((Predicate<Tuple>)tpl -> placeStates.containsValue(tpl.func_76341_a()))).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
        for (BlockPos placePos : placeStates.keySet()) {
            BlockState stateToPlace = placeStates.get(placePos);
            Tuple availableStack = availableStacks.get(stateToPlace);
            if (availableStack == null) continue;
            ItemStack extractable = ItemUtils.copyStackWithSize((ItemStack)availableStack.func_76341_a(), 1);
            boolean canExtract = player.func_184812_l_();
            if (!canExtract && ItemUtils.consumeFromPlayerInventory(player, held, extractable, true)) {
                canExtract = true;
            }
            if (!canExtract || !MiscUtils.canPlayerPlaceBlockPos(player, stateToPlace, placePos, Direction.UP) || !player.func_184812_l_() && !ItemUtils.consumeFromPlayerInventory(player, held, extractable, false) || !AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, 8.0f, false) || !world.func_175656_a(placePos, stateToPlace)) continue;
            PktPlayEffect ev = new PktPlayEffect(PktPlayEffect.Type.BLOCK_EFFECT).addData(buf -> {
                ByteBufUtils.writePos(buf, placePos);
                ByteBufUtils.writeBlockState(buf, stateToPlace);
            });
            PacketChannel.CHANNEL.sendToAllAround(ev, PacketChannel.pointFromPos(world, (Vector3i)placePos, 32.0));
        }
        return ActionResult.func_226248_a_((Object)held);
    }

    @Nonnull
    private Map<BlockPos, BlockState> getPlayerPlaceableStates(PlayerEntity player, ItemStack stack) {
        Map<BlockPos, BlockState> placeStates;
        PlaceMode mode = ItemArchitectWand.getPlaceMode(stack);
        World world = player.func_130014_f_();
        BlockRayTraceResult rtr = MiscUtils.rayTraceLookBlock((Entity)player, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, 60.0);
        if (rtr == null && mode.needsOffset()) {
            return new HashMap<BlockPos, BlockState>();
        }
        if (rtr != null) {
            Direction placingAgainst = rtr.func_216354_b();
            BlockPos at = rtr.func_216350_a().func_177972_a(rtr.func_216354_b());
            placeStates = this.getPlaceStates(player, world, at, placingAgainst, stack);
        } else {
            placeStates = this.getPlaceStates(player, world, null, null, stack);
        }
        return placeStates;
    }

    @Nonnull
    private Map<BlockPos, BlockState> getPlaceStates(PlayerEntity placer, World world, @Nullable BlockPos origin, @Nullable Direction placingAgainst, ItemStack refStack) {
        Map<BlockState, Tuple<ItemStack, Integer>> tplStates = ItemBlockStorage.getInventoryMatching(placer, refStack);
        PlaceMode placeMode = ItemArchitectWand.getPlaceMode(refStack);
        HashMap placeables = Maps.newHashMap();
        int totalItems = 0;
        if (placer.func_184812_l_()) {
            totalItems = Integer.MAX_VALUE;
        } else {
            for (Tuple<ItemStack, Integer> amountTpl : tplStates.values()) {
                totalItems += (Integer)amountTpl.func_76340_b() == -1 ? 500000 : (Integer)amountTpl.func_76340_b();
            }
        }
        List<BlockPos> foundPositions = placeMode.generatePlacementPositions(world, placer, placingAgainst, origin);
        if (foundPositions.isEmpty()) {
            return placeables;
        }
        foundPositions = foundPositions.subList(0, Math.min(foundPositions.size(), totalItems));
        HashMap placeAmounts = Maps.newHashMap();
        for (BlockState state : tplStates.keySet()) {
            placeAmounts.put(state, placer.func_184812_l_() ? Integer.valueOf(Integer.MAX_VALUE) : (Integer)tplStates.get(state).func_76340_b());
        }
        ArrayList placeableStates = Lists.newArrayList(placeAmounts.keySet());
        Random rand = ItemBlockStorage.getPreviewRandomFromWorld(world);
        for (BlockPos pos : foundPositions) {
            Collections.shuffle(placeableStates, rand);
            BlockState toPlace = (BlockState)Iterables.getFirst((Iterable)placeableStates, null);
            if (toPlace == null) continue;
            MiscUtils.executeWithChunk((IWorldReader)world, pos, () -> {
                if (BlockUtils.isReplaceable(world, pos)) {
                    if (!placer.func_184812_l_()) {
                        int count = (Integer)placeAmounts.get(toPlace);
                        if (--count <= 0) {
                            placeAmounts.remove(toPlace);
                            placeableStates.remove(toPlace);
                        } else {
                            placeAmounts.put(toPlace, count);
                        }
                    }
                    placeables.put(pos, toPlace);
                }
            });
        }
        return placeables;
    }

    public static void setPlaceMode(@Nonnull ItemStack stack, @Nonnull PlaceMode mode) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArchitectWand)) {
            return;
        }
        CompoundNBT nbt = NBTHelper.getPersistentData(stack);
        nbt.func_74768_a("placeMode", mode.ordinal());
    }

    @Nonnull
    public static PlaceMode getPlaceMode(@Nonnull ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArchitectWand)) {
            return PlaceMode.TOWARDS_PLAYER;
        }
        CompoundNBT nbt = NBTHelper.getPersistentData(stack);
        return MiscUtils.getEnumEntry(PlaceMode.class, nbt.func_74762_e("placeMode"));
    }

    public static enum PlaceMode {
        TOWARDS_PLAYER("towards", true, 3.0f){

            @Override
            public List<BlockPos> generatePlacementPositions(World world, PlayerEntity player, Direction placedAgainst, BlockPos center) {
                BlockPos at;
                double cmpTo;
                double cmpFrom;
                ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
                switch (placedAgainst.func_176740_k()) {
                    case X: {
                        cmpFrom = center.func_177958_n();
                        cmpTo = player.func_226277_ct_();
                        break;
                    }
                    case Y: {
                        cmpFrom = center.func_177956_o();
                        cmpTo = player.func_226278_cu_();
                        break;
                    }
                    case Z: {
                        cmpFrom = center.func_177952_p();
                        cmpTo = player.func_226281_cx_();
                        break;
                    }
                    default: {
                        return Lists.newLinkedList();
                    }
                }
                int length = (int)Math.min(20.0, Math.abs(cmpFrom + 0.5 - cmpTo));
                for (int i = 0; i < length && !MiscUtils.executeWithChunk((IWorldReader)world, at = center.func_177967_a(placedAgainst, i), () -> !BlockUtils.isReplaceable(world, at), true).booleanValue(); ++i) {
                    blocks.add(at);
                }
                return blocks;
            }
        }
        ,
        FROM_PLAYER("line", false){

            @Override
            public List<BlockPos> generatePlacementPositions(World world, PlayerEntity player, Direction placedAgainst, BlockPos center) {
                BlockPos origin = player.func_233580_cy_().func_177977_b();
                RayTraceResult result = player.func_213324_a(60.0, 1.0f, false);
                BlockPos hit = result instanceof BlockRayTraceResult ? ((BlockRayTraceResult)result).func_216350_a() : new BlockPos(result.func_216347_e());
                ArrayList<BlockPos> line = new ArrayList<BlockPos>();
                RaytraceAssist rta = new RaytraceAssist(origin, hit);
                rta.forEachBlockPos(pos -> MiscUtils.executeWithChunk((IWorldReader)world, pos, () -> {
                    if (BlockUtils.isReplaceable(world, pos)) {
                        line.add((BlockPos)pos);
                        return true;
                    }
                    return false;
                }, false));
                return line;
            }
        }
        ,
        H_PLANE("plane", true){

            @Override
            public List<BlockPos> generatePlacementPositions(World world, PlayerEntity player, Direction placedAgainst, BlockPos center) {
                return MiscUtils.transformList(BlockGeometry.getPlane(Direction.UP, 5), at -> at.func_177971_a((Vector3i)center));
            }
        }
        ,
        V_PLANE("wall", true){

            @Override
            public List<BlockPos> generatePlacementPositions(World world, PlayerEntity player, Direction placedAgainst, BlockPos center) {
                return MiscUtils.transformList(BlockGeometry.getPlane(player.func_174811_aO(), 5), at -> at.func_177971_a((Vector3i)center));
            }
        }
        ,
        SPHERE("sphere", true, 0.2f){

            @Override
            public List<BlockPos> generatePlacementPositions(World world, PlayerEntity player, Direction placedAgainst, BlockPos center) {
                return MiscUtils.transformList(BlockGeometry.getSphere(5.0), at -> at.func_177971_a((Vector3i)center));
            }
        }
        ,
        SPHERE_HOLLOW("sphere_hollow", true, 0.5f){

            @Override
            public List<BlockPos> generatePlacementPositions(World world, PlayerEntity player, Direction placedAgainst, BlockPos center) {
                return MiscUtils.transformList(BlockGeometry.getHollowSphere(5.0, 4.0), at -> at.func_177971_a((Vector3i)center));
            }
        };

        private final String name;
        private final boolean needsOffset;
        private final float placeCostMulitplier;

        private PlaceMode(String name, boolean needsOffset) {
            this(name, needsOffset, 1.0f);
        }

        private PlaceMode(String name, boolean needsOffset, float placeCostMultiplier) {
            this.name = name;
            this.needsOffset = needsOffset;
            this.placeCostMulitplier = placeCostMultiplier;
        }

        public IFormattableTextComponent getName() {
            return new TranslationTextComponent("astralsorcery.misc.architect.mode." + this.name);
        }

        public IFormattableTextComponent getDisplay() {
            return new TranslationTextComponent("astralsorcery.misc.architect.mode", new Object[]{this.getName()});
        }

        public float getPlaceCostMulitplier() {
            return this.placeCostMulitplier;
        }

        public boolean needsOffset() {
            return this.needsOffset;
        }

        public abstract List<BlockPos> generatePlacementPositions(World var1, PlayerEntity var2, Direction var3, BlockPos var4);

        @Nonnull
        private PlaceMode next() {
            int next = (this.ordinal() + 1) % PlaceMode.values().length;
            return MiscUtils.getEnumEntry(PlaceMode.class, next);
        }
    }
}

