/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.lens;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLens;
import hellfirepvp.astralsorcery.common.item.lens.LensColorType;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.util.PartialEffectExecutor;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemColoredLensFire
extends ItemColoredLens {
    private static final ColorTypeFire COLOR_TYPE_FIRE = new ColorTypeFire();

    public ItemColoredLensFire() {
        super(COLOR_TYPE_FIRE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playParticles(PktPlayEffect event) {
        Vector3 at = ByteBufUtils.readVector(event.getExtraData());
        for (int i = 0; i < 5; ++i) {
            ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at.clone().add((double)field_77697_d.nextFloat(), 0.2, (double)field_77697_d.nextFloat()))).setMotion(new Vector3(0.0, 0.016 + (double)field_77697_d.nextFloat() * 0.02, 0.0))).setScaleMultiplier(0.2f)).color(VFXColorFunction.constant(ColorsAS.COLORED_LENS_FIRE));
        }
    }

    private static class ColorTypeFire
    extends LensColorType {
        private ColorTypeFire() {
            super(AstralSorcery.key("fire"), LensColorType.TargetType.ANY, () -> new ItemStack((IItemProvider)ItemsAS.COLORED_LENS_FIRE), ColorsAS.COLORED_LENS_FIRE, 0.1f, false);
        }

        @Override
        public void entityInBeam(World world, Vector3 origin, Vector3 target, Entity entity, PartialEffectExecutor executor) {
            if (world.func_201670_d()) {
                return;
            }
            if (entity instanceof ItemEntity) {
                ItemStack current = ((ItemEntity)entity).func_92059_d();
                ItemStack result = RecipeHelper.findSmeltingResult(entity.func_130014_f_(), current).orElse(ItemStack.field_190927_a);
                if (result.func_190926_b()) {
                    return;
                }
                while (executor.canExecute()) {
                    executor.markExecution();
                    if (field_77697_d.nextInt(10) != 0) continue;
                    Vector3 entityPos = Vector3.atEntityCorner(entity);
                    ItemUtils.dropItemNaturally(entity.func_130014_f_(), entityPos.getX(), entityPos.getY(), entityPos.getZ(), ItemUtils.copyStackWithSize(result, result.func_190916_E()));
                    if (current.func_190916_E() > 1) {
                        current.func_190918_g(1);
                        ((ItemEntity)entity).func_92058_a(current);
                    } else {
                        entity.func_70106_y();
                    }
                    return;
                }
            } else if (entity instanceof LivingEntity) {
                if (!(!(entity instanceof PlayerEntity) || ((Boolean)GeneralConfig.CONFIG.doColoredLensesAffectPlayers.get()).booleanValue() && entity.func_184102_h() != null && entity.func_184102_h().func_71219_W())) {
                    return;
                }
                entity.func_70097_a(DamageSource.field_76370_b, 0.5f);
                entity.func_70015_d(5);
            }
        }

        @Override
        public void blockInBeam(World world, BlockPos pos, BlockState state, PartialEffectExecutor executor) {
            if (!(world instanceof ServerWorld)) {
                return;
            }
            ItemStack blockStack = ItemUtils.createBlockStack(state);
            if (blockStack.func_190926_b()) {
                return;
            }
            ItemStack result = RecipeHelper.findSmeltingResult(world, blockStack).orElse(ItemStack.field_190927_a);
            if (result.func_190926_b()) {
                return;
            }
            PktPlayEffect ev = new PktPlayEffect(PktPlayEffect.Type.MELT_BLOCK).addData(buf -> ByteBufUtils.writeVector(buf, new Vector3((Vector3i)pos)));
            PacketChannel.CHANNEL.sendToAllAround(ev, PacketChannel.pointFromPos(world, (Vector3i)pos, 16.0));
            while (executor.canExecute()) {
                executor.markExecution();
                if (field_77697_d.nextInt(6) != 0) continue;
                BlockState resState = ItemUtils.createBlockState(result);
                if (resState != null) {
                    world.func_180501_a(pos, resState, 3);
                } else if (world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3)) {
                    ItemUtils.dropItemNaturally(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, result);
                }
                return;
            }
        }
    }
}

