/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entity;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityNocturnalSpark
extends ThrowableEntity {
    private static final AxisAlignedBB NO_DUPE_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g(15.0);
    private static final DataParameter<Boolean> SPAWNING = EntityDataManager.func_187226_a(EntityNocturnalSpark.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int ticksSpawning = 0;

    public EntityNocturnalSpark(World world) {
        super(EntityTypesAS.NOCTURNAL_SPARK, world);
    }

    public EntityNocturnalSpark(double x, double y, double z, World world) {
        super(EntityTypesAS.NOCTURNAL_SPARK, x, y, z, world);
    }

    public EntityNocturnalSpark(LivingEntity thrower, World world) {
        super(EntityTypesAS.NOCTURNAL_SPARK, thrower, world);
        this.func_234612_a_((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 0.7f, 0.9f);
    }

    public static EntityType.IFactory<EntityNocturnalSpark> factory() {
        return (type, world) -> new EntityNocturnalSpark(world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SPAWNING, (Object)false);
    }

    public void setSpawning() {
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70180_af.func_187227_b(SPAWNING, (Object)true);
    }

    public boolean isSpawning() {
        return (Boolean)this.field_70180_af.func_187225_a(SPAWNING);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70089_S()) {
            return;
        }
        if (!this.field_70170_p.func_201670_d()) {
            this.removeLights();
            if (this.isSpawning()) {
                ++this.ticksSpawning;
                this.spawnCycle();
                this.removeDuplicates();
                if (this.ticksSpawning > 200) {
                    this.func_70106_y();
                }
            }
        } else {
            this.spawnEffects();
        }
    }

    private void removeLights() {
        if (this.func_130014_f_() instanceof ServerWorld) {
            ServerWorld sWorld = (ServerWorld)this.func_130014_f_();
            if (this.field_70173_aa % 5 == 0) {
                List<BlockPos> lightPositions = BlockDiscoverer.searchForBlocksAround((World)sWorld, this.func_233580_cy_(), 8, (world, pos, state) -> !(state.func_177230_c() instanceof AirBlock) && state.func_185887_b((IBlockReader)world, pos) != -1.0f && state.getLightValue((IBlockReader)world, pos) > 3);
                for (BlockPos light : lightPositions) {
                    if (BlockUtils.breakBlockWithoutPlayer(sWorld, light, sWorld.func_180495_p(light), ItemStack.field_190927_a, true, true)) continue;
                    sWorld.func_217377_a(light, false);
                }
            }
        }
    }

    private void removeDuplicates() {
        List sparks = this.field_70170_p.func_217357_a(EntityNocturnalSpark.class, NO_DUPE_BOX.func_186670_a(this.func_233580_cy_()));
        for (EntityNocturnalSpark spark : sparks) {
            if (this.equals((Object)spark) || !spark.func_70089_S() || !spark.isSpawning()) continue;
            spark.func_70106_y();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnEffects() {
        if (this.isSpawning()) {
            for (int i = 0; i < 15; ++i) {
                Vector3 thisPos = Vector3.atEntityCorner((Entity)this).addY(1.0);
                MiscUtils.applyRandomOffset(thisPos, this.field_70146_Z, 2 + this.field_70146_Z.nextInt(4));
                FXFacingParticle p = (FXFacingParticle)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(thisPos)).setScaleMultiplier(4.0f)).alpha(VFXAlphaFunction.PYRAMID)).setAlphaMultiplier(0.7f)).color(VFXColorFunction.constant(Color.BLACK));
                if (this.field_70146_Z.nextInt(5) == 0) {
                    this.randomizeColor(p);
                }
                if (this.field_70146_Z.nextInt(20) != 0) continue;
                Vector3 at = Vector3.atEntityCorner((Entity)this);
                MiscUtils.applyRandomOffset(at, this.field_70146_Z, 2.0f);
                Vector3 to = Vector3.atEntityCorner((Entity)this);
                MiscUtils.applyRandomOffset(to, this.field_70146_Z, 2.0f);
                ((FXLightning)EffectHelper.of(EffectTemplatesAS.LIGHTNING).spawn(at)).makeDefault(to).color(VFXColorFunction.constant(Color.BLACK));
            }
        } else {
            FXFacingParticle p;
            for (int i = 0; i < 6; ++i) {
                p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)this))).setMotion(new Vector3(0.04f - this.field_70146_Z.nextFloat() * 0.08f, 0.04f - this.field_70146_Z.nextFloat() * 0.08f, 0.04f - this.field_70146_Z.nextFloat() * 0.08f))).setScaleMultiplier(0.25f);
                this.randomizeColor(p);
            }
            p = (FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)this));
            p.setScaleMultiplier(0.6f);
            this.randomizeColor(p);
            p = (FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)this).add(this.func_213322_ci().func_216372_d(0.5, 0.5, 0.5)));
            p.setScaleMultiplier(0.6f);
            this.randomizeColor(p);
        }
    }

    private void spawnCycle() {
        if (this.field_70146_Z.nextInt(12) == 0 && this.field_70170_p instanceof ServerWorld) {
            BlockPos pos = this.func_233580_cy_();
            pos.func_177982_a(this.field_70146_Z.nextInt(2) - this.field_70146_Z.nextInt(2), 1, this.field_70146_Z.nextInt(2) - this.field_70146_Z.nextInt(2));
            pos = BlockUtils.firstSolidDown((IBlockReader)this.field_70170_p, pos).func_177984_a();
            if (pos.func_177951_i((Vector3i)this.func_233580_cy_()) >= 16.0) {
                return;
            }
            EntityUtils.performWorldSpawningAt((ServerWorld)this.field_70170_p, pos, EntityClassification.MONSTER, SpawnReason.SPAWNER, true, 11);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void randomizeColor(FXFacingParticle p) {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                p.color(VFXColorFunction.constant(ColorsAS.NOCTURNAL_POWDER_1));
                break;
            }
            case 1: {
                p.color(VFXColorFunction.constant(ColorsAS.NOCTURNAL_POWDER_2));
                break;
            }
            case 2: {
                p.color(VFXColorFunction.constant(ColorsAS.NOCTURNAL_POWDER_3));
                break;
            }
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (RayTraceResult.Type.ENTITY.equals((Object)result.func_216346_c())) {
            return;
        }
        Vector3d hit = result.func_216347_e();
        this.setSpawning();
        this.func_70107_b(hit.field_72450_a, hit.field_72448_b, hit.field_72449_c);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

