/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantmentHelper;
import hellfirepvp.astralsorcery.common.integration.IntegrationCurios;
import hellfirepvp.astralsorcery.common.item.ItemEnchantmentAmulet;
import hellfirepvp.astralsorcery.common.util.item.ItemComparator;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class AmuletEnchantmentHelper {
    public static final String KEY_AS_OWNER = "AS_Amulet_Holder";

    public static void removeAmuletTagsAndCleanup(PlayerEntity player, boolean keepEquipped) {
        int i;
        PlayerInventory inv = player.field_71071_by;
        for (i = 0; i < inv.field_70462_a.size(); ++i) {
            if (i == inv.field_70461_c && keepEquipped) continue;
            AmuletEnchantmentHelper.removeAmuletOwner((ItemStack)inv.field_70462_a.get(i));
        }
        AmuletEnchantmentHelper.removeAmuletOwner(inv.func_70445_o());
        if (!keepEquipped) {
            for (i = 0; i < inv.field_70460_b.size(); ++i) {
                AmuletEnchantmentHelper.removeAmuletOwner((ItemStack)inv.field_70460_b.get(i));
            }
            for (i = 0; i < inv.field_184439_c.size(); ++i) {
                AmuletEnchantmentHelper.removeAmuletOwner((ItemStack)inv.field_184439_c.get(i));
            }
        }
    }

    @Nonnull
    private static UUID getWornPlayerUUID(ItemStack anyTool) {
        if (DynamicEnchantmentHelper.canHaveDynamicEnchantment(anyTool) && anyTool.func_77942_o()) {
            return NBTHelper.getUUID(anyTool.func_77978_p(), KEY_AS_OWNER, Util.field_240973_b_);
        }
        return Util.field_240973_b_;
    }

    public static void applyAmuletOwner(ItemStack tool, PlayerEntity wearer) {
        if (DynamicEnchantmentHelper.canHaveDynamicEnchantment(tool)) {
            tool.func_196082_o().func_186854_a(KEY_AS_OWNER, wearer.func_110124_au());
        }
    }

    private static void removeAmuletOwner(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return;
        }
        NBTHelper.removeUUID(stack.func_77978_p(), KEY_AS_OWNER);
        if (stack.func_77978_p().isEmpty()) {
            stack.func_77982_d(null);
        }
    }

    @Nullable
    public static PlayerEntity getPlayerHavingTool(ItemStack anyTool) {
        PlayerEntity player;
        UUID plUUID = AmuletEnchantmentHelper.getWornPlayerUUID(anyTool);
        if (plUUID.getLeastSignificantBits() == 0L && plUUID.getMostSignificantBits() == 0L) {
            return null;
        }
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            player = AmuletEnchantmentHelper.resolvePlayerClient(plUUID);
        } else {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            if (server == null) {
                return null;
            }
            player = server.func_184103_al().func_177451_a(plUUID);
        }
        if (player == null) {
            return null;
        }
        ItemStack cmpThis = anyTool.func_77946_l();
        cmpThis.func_196085_b(0);
        boolean foundTool = false;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = player.func_184582_a(slot).func_77946_l();
            stack.func_196085_b(0);
            if (!ItemComparator.compare(stack, cmpThis, ItemComparator.Clause.Sets.ITEMSTACK_STRICT)) continue;
            foundTool = true;
            break;
        }
        if (!foundTool) {
            return null;
        }
        return player;
    }

    @Nullable
    static Tuple<ItemStack, PlayerEntity> getWornAmulet(ItemStack anyTool) {
        PlayerEntity player = AmuletEnchantmentHelper.getPlayerHavingTool(anyTool);
        if (player == null) {
            return null;
        }
        Optional<ImmutableTriple<String, Integer, ItemStack>> curios = IntegrationCurios.getCurio(player, stack -> stack.func_77973_b() instanceof ItemEnchantmentAmulet);
        return curios.map(trpl -> new Tuple(trpl.right, (Object)player)).orElse(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PlayerEntity resolvePlayerClient(UUID plUUID) {
        Optional w = (Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT);
        return w.map(world -> world.func_217371_b(plUUID)).orElse(null);
    }
}

