/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.server;

import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractDataProvider;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientTimeFreezeEntities;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class DataTimeFreezeEntities
extends AbstractData {
    private final Map<RegistryKey<World>, Set<Integer>> serverActiveEntityFreeze = new HashMap<RegistryKey<World>, Set<Integer>>();
    private final Set<RegistryKey<World>> serverSyncTypes = new HashSet<RegistryKey<World>>();

    private DataTimeFreezeEntities(ResourceLocation key) {
        super(key);
    }

    public void freezeEntity(Entity e) {
        RegistryKey dim = e.func_130014_f_().func_234923_W_();
        if (this.serverActiveEntityFreeze.computeIfAbsent((RegistryKey<World>)dim, dimType -> new HashSet()).add(e.func_145782_y())) {
            this.serverSyncTypes.add((RegistryKey<World>)dim);
            this.markDirty();
        }
    }

    public void unfreezeEntity(Entity e) {
        RegistryKey dim = e.func_130014_f_().func_234923_W_();
        if (this.serverActiveEntityFreeze.getOrDefault(dim, Collections.emptySet()).remove(e.func_145782_y())) {
            this.serverSyncTypes.add((RegistryKey<World>)dim);
            this.markDirty();
        }
    }

    public boolean isFrozen(Entity e) {
        RegistryKey dim = e.func_130014_f_().func_234923_W_();
        return this.serverActiveEntityFreeze.getOrDefault(dim, Collections.emptySet()).contains(e.func_145782_y());
    }

    @Override
    public void clear(RegistryKey<World> dimType) {
        this.serverActiveEntityFreeze.remove(dimType);
    }

    @Override
    public void clearServer() {
        this.serverActiveEntityFreeze.clear();
        this.serverSyncTypes.clear();
    }

    @Override
    public void writeAllDataToPacket(CompoundNBT compound) {
        this.writeEntityInformation(compound, this.serverActiveEntityFreeze);
    }

    @Override
    public void writeDiffDataToPacket(CompoundNBT compound) {
        HashMap<RegistryKey<World>, Set<Integer>> entities = new HashMap<RegistryKey<World>, Set<Integer>>();
        this.serverSyncTypes.forEach(type -> entities.put((RegistryKey<World>)type, this.serverActiveEntityFreeze.getOrDefault(type, new HashSet())));
        this.writeEntityInformation(compound, entities);
        this.serverSyncTypes.clear();
    }

    private void writeEntityInformation(CompoundNBT out, Map<RegistryKey<World>, Set<Integer>> entities) {
        CompoundNBT dimTag = new CompoundNBT();
        entities.forEach((dim, entityIds) -> {
            ListNBT nbtEntities = new ListNBT();
            entityIds.forEach(id -> nbtEntities.add((Object)IntNBT.func_229692_a_((int)id)));
            dimTag.func_218657_a(dim.func_240901_a_().toString(), (INBT)nbtEntities);
        });
        out.func_218657_a("dimTypes", (INBT)dimTag);
    }

    public static class Provider
    extends AbstractDataProvider<DataTimeFreezeEntities, ClientTimeFreezeEntities> {
        public Provider(ResourceLocation key) {
            super(key);
        }

        @Override
        public DataTimeFreezeEntities provideServerData() {
            return new DataTimeFreezeEntities(this.getKey());
        }

        @Override
        public ClientTimeFreezeEntities provideClientData() {
            return new ClientTimeFreezeEntities();
        }

        @Override
        public ClientDataReader<ClientTimeFreezeEntities> createReader() {
            return new ClientTimeFreezeEntities.Reader();
        }
    }
}

