/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.resource.query.SpriteQuery;
import hellfirepvp.astralsorcery.client.resource.query.TextureQuery;
import hellfirepvp.astralsorcery.common.auxiliary.book.BookLookupRegistry;
import hellfirepvp.astralsorcery.common.data.journal.JournalPage;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ResearchNode {
    private static int counter = 0;
    private final int id;
    private final NodeRenderType nodeRenderType;
    public final float renderPosX;
    public final float renderPosZ;
    private final String unlocName;
    private ItemStack[] renderItemStacks;
    private SpriteQuery renderSpriteQuery;
    private TextureQuery backgroundTextureQuery = new TextureQuery(AssetLoader.TextureLocation.GUI, "research_frame_wood");
    private Color textureColorHint = new Color(-1, true);
    private final List<ResearchNode> connectionsTo = new ArrayList<ResearchNode>();
    private final List<JournalPage> pages = new LinkedList<JournalPage>();

    private ResearchNode(NodeRenderType type, String unlocName, float rPosX, float rPosZ) {
        this.id = counter++;
        this.nodeRenderType = type;
        this.renderPosX = rPosX;
        this.renderPosZ = rPosZ;
        this.unlocName = unlocName;
    }

    public ResearchNode(IItemProvider item, String unlocName, float renderPosX, float renderPosZ) {
        this(new ItemStack(item), unlocName, renderPosX, renderPosZ);
    }

    public ResearchNode(ItemStack itemStack, String unlocName, float renderPosX, float renderPosZ) {
        this(NodeRenderType.ITEMSTACK, unlocName, renderPosX, renderPosZ);
        this.renderItemStacks = new ItemStack[]{itemStack};
    }

    public ResearchNode(IItemProvider[] items, String unlocName, float renderPosX, float renderPosZ) {
        this(NodeRenderType.ITEMSTACK, unlocName, renderPosX, renderPosZ);
        this.renderItemStacks = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.renderItemStacks[i] = new ItemStack(items[i]);
        }
    }

    public ResearchNode(ItemStack[] stacks, String unlocName, float renderPosX, float renderPosZ) {
        this(NodeRenderType.ITEMSTACK, unlocName, renderPosX, renderPosZ);
        this.renderItemStacks = stacks;
    }

    public ResearchNode(SpriteQuery query, String unlocName, float renderPosX, float renderPosZ) {
        this(NodeRenderType.TEXTURE_SPRITE, unlocName, renderPosX, renderPosZ);
        this.renderSpriteQuery = query;
    }

    public ResearchNode addSourceConnectionFrom(ResearchNode node) {
        this.connectionsTo.add(node);
        return this;
    }

    public ResearchNode addSourceConnectionFrom(ResearchNode ... node) {
        return this.addSourceConnectionsFrom(Arrays.asList(node));
    }

    public ResearchNode addSourceConnectionsFrom(Collection<ResearchNode> node) {
        this.connectionsTo.addAll(node);
        return this;
    }

    public List<ResearchNode> getConnectionsTo() {
        return this.connectionsTo;
    }

    public ResearchNode addPage(JournalPage page) {
        this.pages.add(page);
        return this;
    }

    public boolean canSee(@Nullable PlayerProgress progress) {
        return true;
    }

    public ResearchNode setTextureColorHintWithAlpha(Color textureColorHint) {
        this.textureColorHint = textureColorHint;
        return this;
    }

    public ResearchNode register(ResearchProgression progression) {
        progression.getRegistrar().accept(this);
        return this;
    }

    public ResearchNode addTomeLookup(IItemProvider item, int nodePage, ResearchProgression progression) {
        BookLookupRegistry.registerItemLookup(item, this, nodePage, progression);
        return this;
    }

    public ResearchNode addTomeLookup(ItemStack item, int nodePage, ResearchProgression progression) {
        BookLookupRegistry.registerItemLookup(item, this, nodePage, progression);
        return this;
    }

    public Color getTextureColorHint() {
        return this.textureColorHint;
    }

    public NodeRenderType getNodeRenderType() {
        return this.nodeRenderType;
    }

    public ItemStack getRenderItemStack() {
        return this.getRenderItemStack(0L);
    }

    public ItemStack getRenderItemStack(long tick) {
        return this.renderItemStacks[(int)(tick / 40L % (long)this.renderItemStacks.length)];
    }

    public TextureQuery getBackgroundTexture() {
        return this.backgroundTextureQuery;
    }

    public SpriteQuery getSpriteTexture() {
        return this.renderSpriteQuery;
    }

    public List<JournalPage> getPages() {
        return this.pages;
    }

    public ITextComponent getName() {
        return new TranslationTextComponent(String.format("astralsorcery.journal.node.%s.name", this.getKey()));
    }

    public String getKey() {
        return this.unlocName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResearchNode that = (ResearchNode)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public static enum NodeRenderType {
        ITEMSTACK,
        TEXTURE_SPRITE;

    }
}

