/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.interaction;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.InteractionResult;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.InteractionResultRegistry;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ResultSpawnEntity
extends InteractionResult {
    private EntityType<?> entityType;

    ResultSpawnEntity() {
        super(InteractionResultRegistry.ID_SPAWN_ENTITY);
    }

    public static ResultSpawnEntity spawnEntity(EntityType<?> type) {
        if (!type.func_200720_b()) {
            throw new IllegalArgumentException("EntityType " + type.getRegistryName() + " is not summonable!");
        }
        ResultSpawnEntity drop = new ResultSpawnEntity();
        drop.entityType = type;
        return drop;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    @Override
    public void doResult(World world, Vector3 at) {
        Entity e = this.entityType.func_200721_a(world);
        if (!(e instanceof LivingEntity)) {
            return;
        }
        e.func_70012_b(at.getX(), at.getY(), at.getZ(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_217376_c(e);
    }

    @Override
    public void read(JsonObject json) throws JsonParseException {
        ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"entityType"));
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(key);
        if (type == null) {
            throw new JsonParseException("Unknown entity type: " + key);
        }
        this.entityType = type;
    }

    @Override
    public void write(JsonObject json) {
        json.addProperty("entityType", this.entityType.getRegistryName().toString());
    }

    @Override
    public void read(PacketBuffer buf) {
        this.entityType = (EntityType)ByteBufUtils.readRegistryEntry(buf);
    }

    @Override
    public void write(PacketBuffer buf) {
        ByteBufUtils.writeRegistryEntry(buf, this.entityType);
    }
}

