/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.starlight;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.crafting.nojson.starlight.LiquidStarlightRecipe;
import hellfirepvp.astralsorcery.common.data.config.entry.CraftingConfig;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InfusedWoodRecipe
extends LiquidStarlightRecipe {
    public InfusedWoodRecipe() {
        super(AstralSorcery.key("infused_wood"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Ingredient> getInputForRender() {
        return Collections.singletonList(Ingredient.func_199805_a((ITag)ItemTags.field_200038_h));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Ingredient> getOutputForRender() {
        return Collections.singletonList(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{BlocksAS.INFUSED_WOOD}));
    }

    @Override
    public boolean doesStartRecipe(ItemStack item) {
        if (!((Boolean)CraftingConfig.CONFIG.liquidStarlightDropInfusedWood.get()).booleanValue()) {
            return false;
        }
        return item.func_77973_b().func_206844_a((ITag)ItemTags.field_200038_h);
    }

    @Override
    public boolean matches(ItemEntity trigger, World world, BlockPos at) {
        return true;
    }

    @Override
    public void doServerCraftTick(ItemEntity trigger, World world, BlockPos at) {
        if (this.getAndIncrementCraftingTick((Entity)trigger) > 10 && this.consumeItemEntityInBlock((IWorld)world, at, 1, stack -> !stack.func_190926_b() && stack.func_77973_b().func_206844_a((ITag)ItemTags.field_200038_h)) != null) {
            ItemUtils.dropItemNaturally(world, trigger.func_226277_ct_(), trigger.func_226278_cu_(), trigger.func_226281_cx_(), new ItemStack((IItemProvider)BlocksAS.INFUSED_WOOD));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doClientEffectTick(ItemEntity trigger, World world, BlockPos at) {
        for (int i = 0; i < 4; ++i) {
            Vector3 pos = new Vector3((Vector3i)at).add(0.5, 0.5, 0.5);
            MiscUtils.applyRandomOffset(pos, rand, 0.5f);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).color(VFXColorFunction.constant(ColorsAS.DYE_BROWN))).alpha(VFXAlphaFunction.PYRAMID)).setScaleMultiplier(0.1f + rand.nextFloat() * 0.1f)).setMaxAge(30 + rand.nextInt(20));
        }
    }
}

