/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.freezing;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.nojson.freezing.WorldFreezingRecipe;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicates;
import hellfirepvp.astralsorcery.common.util.block.WorldBlockPos;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockFreezingRecipe
extends WorldFreezingRecipe {
    private final BiFunction<WorldBlockPos, BlockState, BlockState> outputGenerator;

    public BlockFreezingRecipe(ResourceLocation key, BlockPredicate matcher, BlockState output) {
        this(key, matcher, (WorldBlockPos worldPos, BlockState state) -> output);
    }

    public BlockFreezingRecipe(ResourceLocation key, BlockPredicate matcher, BiFunction<WorldBlockPos, BlockState, BlockState> outputGenerator) {
        super(key, matcher);
        this.outputGenerator = outputGenerator;
    }

    public static BlockFreezingRecipe of(BlockState stateIn, BlockState stateOut) {
        return new BlockFreezingRecipe(AstralSorcery.key(stateIn.func_177230_c().getRegistryName().func_110623_a()), BlockPredicates.isState(stateIn), stateOut);
    }

    public static BlockFreezingRecipe of(Block blockIn, BlockState stateOut) {
        return new BlockFreezingRecipe(AstralSorcery.key(blockIn.getRegistryName().func_110623_a()), BlockPredicates.isBlock(blockIn), stateOut);
    }

    public static BlockFreezingRecipe of(ITag.INamedTag<Block> blockTagIn, BlockState stateOut) {
        return new BlockFreezingRecipe(AstralSorcery.key(String.format("tag_%s", blockTagIn.func_230234_a_().func_110623_a())), BlockPredicates.isInTag(blockTagIn), stateOut);
    }

    @Override
    public void doOutput(World world, BlockPos pos, BlockState state, Consumer<ItemStack> itemOutput) {
        BlockState generated = this.outputGenerator.apply(WorldBlockPos.wrapServer(world, pos), state);
        if (generated != state) {
            world.func_180501_a(pos, generated, 11);
        }
    }
}

