/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.base;

import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class ListEntries {

    public static class PosEntry
    implements CEffectAbstractList.ListEntry {
        private final BlockPos pos;

        public PosEntry(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void writeToNBT(CompoundNBT nbt) {
        }

        @Override
        public void readFromNBT(CompoundNBT nbt) {
        }
    }

    public static class CounterEntry
    extends PosEntry {
        private int counter = 0;

        public CounterEntry(BlockPos pos) {
            super(pos);
        }

        public int getCounter() {
            return this.counter;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        @Override
        public void writeToNBT(CompoundNBT nbt) {
            super.writeToNBT(nbt);
            nbt.func_74768_a("counter", this.counter);
        }

        @Override
        public void readFromNBT(CompoundNBT nbt) {
            super.readFromNBT(nbt);
            this.counter = nbt.func_74762_e("counter");
        }
    }

    public static class CounterMaxEntry
    extends CounterEntry {
        private int maxCount;

        public CounterMaxEntry(BlockPos pos) {
            super(pos);
        }

        public CounterMaxEntry(BlockPos pos, int maxCount) {
            super(pos);
            this.maxCount = maxCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public void setMaxCount(int maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public void writeToNBT(CompoundNBT nbt) {
            super.writeToNBT(nbt);
            nbt.func_74768_a("maxCount", this.maxCount);
        }

        @Override
        public void readFromNBT(CompoundNBT nbt) {
            super.readFromNBT(nbt);
            this.maxCount = nbt.func_74762_e("maxCount");
        }
    }

    public static class EntitySpawnEntry
    extends CounterEntry {
        private EntityType<?> type;

        public EntitySpawnEntry(BlockPos pos) {
            super(pos);
        }

        public EntitySpawnEntry(BlockPos pos, EntityType<?> type) {
            super(pos);
            this.type = type;
        }

        @Override
        public void readFromNBT(CompoundNBT nbt) {
            super.readFromNBT(nbt);
            this.type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(nbt.func_74779_i("entity")));
        }

        @Override
        public void writeToNBT(CompoundNBT nbt) {
            super.writeToNBT(nbt);
            nbt.func_74778_a("entity", this.type.getRegistryName().toString());
        }

        public static EntitySpawnEntry createEntry(ServerWorld world, BlockPos pos, SpawnReason reason) {
            Biome b = world.func_226691_t_(pos);
            LinkedList applicable = new LinkedList();
            if (DayTimeHelper.isNight((World)world)) {
                applicable.addAll(b.func_242433_b().func_242559_a(EntityClassification.MONSTER));
            } else {
                applicable.addAll(b.func_242433_b().func_242559_a(EntityClassification.CREATURE));
            }
            if (applicable.isEmpty()) {
                return null;
            }
            Collections.shuffle(applicable);
            MobSpawnInfo.Spawners entry = (MobSpawnInfo.Spawners)applicable.get(world.field_73012_v.nextInt(applicable.size()));
            EntityType type = entry.field_242588_c;
            if (type != null && EntityUtils.canEntitySpawnHere(world, pos, (EntityType<? extends Entity>)type, reason, 9, e -> e.func_184211_a("skip.spawn.deny"))) {
                return new EntitySpawnEntry(pos, type);
            }
            return null;
        }

        public void spawn(ServerWorld world, SpawnReason reason) {
            if (this.type == null) {
                return;
            }
            Entity e = this.type.func_200721_a((World)world);
            if (e != null) {
                BlockPos at = this.getPos();
                e.func_70012_b((double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (e instanceof MobEntity) {
                    ((MobEntity)e).func_213386_a((IServerWorld)world, world.func_175649_E(at), reason, null, null);
                    if (!((MobEntity)e).func_205019_a((IWorldReader)world)) {
                        e.func_70106_y();
                        return;
                    }
                }
                e.func_184211_a("skip.spawn.deny");
                world.func_217376_c(e);
                world.func_217379_c(2004, e.func_233580_cy_(), 0);
                world.func_217379_c(2004, e.func_233580_cy_(), 0);
            }
        }
    }
}

