/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.screen.base.ScreenCustomContainer;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.container.ContainerAltarBase;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipeContext;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.LogicalSide;

public abstract class ScreenContainerAltar<T extends ContainerAltarBase>
extends ScreenCustomContainer<T> {
    public ScreenContainerAltar(T screenContainer, PlayerInventory inv, ITextComponent name, int width, int height) {
        super(screenContainer, inv, name, width, height);
    }

    @Nullable
    public SimpleAltarRecipe findRecipe(boolean ignoreStarlightRequirement) {
        TileAltar ta = (TileAltar)((ContainerAltarBase)((Object)this.func_212873_a_())).getTileEntity();
        return RecipeTypesAS.TYPE_ALTAR.findRecipe(new SimpleAltarRecipeContext((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT, ta).setIgnoreStarlightRequirement(ignoreStarlightRequirement));
    }

    @Override
    protected void func_230450_a_(MatrixStack renderStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.enableDepthTest();
        this.renderGuiBackground(renderStack, partialTicks, mouseX, mouseY);
        super.func_230450_a_(renderStack, partialTicks, mouseX, mouseY);
    }

    protected void renderStarlightBar(MatrixStack renderStack, int offsetX, int offsetZ, int width, int height) {
        Color barColor;
        float percFilled;
        TileAltar altar = (TileAltar)((ContainerAltarBase)((Object)this.func_212873_a_())).getTileEntity();
        RenderSystem.disableAlphaTest();
        TexturesAS.TEX_BLACK.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this.field_147003_i + offsetX, this.field_147009_r + offsetZ, this.func_230927_p_(), width, height).draw());
        if (altar.hasMultiblock()) {
            percFilled = altar.getAmbientStarlightPercent();
            barColor = Color.WHITE;
        } else {
            percFilled = 1.0f;
            barColor = Color.RED;
        }
        if (percFilled > 0.0f) {
            SimpleAltarRecipe aar;
            SpriteSheetResource spriteStarlight = SpritesAS.SPR_STARLIGHT_STORE;
            spriteStarlight.getResource().bindTexture();
            int tick = altar.getTicksExisted();
            Tuple<Float, Float> uvOffset = spriteStarlight.getUVOffset(tick);
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this.field_147003_i + offsetX, this.field_147009_r + offsetZ, this.func_230927_p_(), (int)((float)width * percFilled), height).tex(((Float)uvOffset.func_76341_a()).floatValue(), ((Float)uvOffset.func_76340_b()).floatValue(), spriteStarlight.getULength() * percFilled, spriteStarlight.getVLength()).color(barColor).draw());
            if (altar.hasMultiblock() && (aar = this.findRecipe(true)) != null) {
                int req = aar.getStarlightRequirement();
                int has = altar.getStoredStarlight();
                if (has < req) {
                    int max = altar.getAltarType().getStarlightCapacity();
                    float percReq = (float)(req - has) / (float)max;
                    int from = (int)((float)width * percFilled);
                    int to = (int)((float)width * percReq);
                    RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this.field_147003_i + offsetX + from, this.field_147009_r + offsetZ, this.func_230927_p_(), to, height).tex(((Float)uvOffset.func_76341_a()).floatValue() + spriteStarlight.getULength() * percFilled, ((Float)uvOffset.func_76340_b()).floatValue(), spriteStarlight.getULength() * percReq, spriteStarlight.getVLength()).color(0.2f, 0.5f, 1.0f, 0.4f).draw());
                }
            }
        }
        RenderSystem.enableAlphaTest();
    }

    public abstract void renderGuiBackground(MatrixStack var1, float var2, int var3, int var4);
}

