/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.ConstellationDiscoveryScreen;
import hellfirepvp.astralsorcery.client.screen.base.SkyScreen;
import hellfirepvp.astralsorcery.client.screen.base.TileConstellationDiscoveryScreen;
import hellfirepvp.astralsorcery.client.screen.telescope.FullScreenDrawArea;
import hellfirepvp.astralsorcery.client.screen.telescope.PlayerAngledConstellationInformation;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.container.ContainerObservatory;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import org.lwjgl.opengl.GL11;

public class ScreenObservatory
extends TileConstellationDiscoveryScreen<TileObservatory, ConstellationDiscoveryScreen.DrawArea>
implements IHasContainer<ContainerObservatory> {
    private static final Random RAND = new Random();
    private static final int FRAME_TEXTURE_SIZE = 16;
    private static final int randomStars = 220;
    private final List<Point2D.Float> usedStars = new ArrayList<Point2D.Float>(220);
    private final ContainerObservatory container;

    public ScreenObservatory(ContainerObservatory container) {
        super(container.getTileEntity(), Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 32, Minecraft.func_71410_x().func_228018_at_().func_198107_o() - 32);
        this.container = container;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            TileObservatory observatory = (TileObservatory)this.getTile();
            player.field_70125_A = observatory.observatoryPitch;
            player.field_70127_C = observatory.prevObservatoryPitch;
            player.field_70177_z = observatory.observatoryYaw;
            player.field_70126_B = observatory.prevObservatoryYaw;
        }
    }

    public ContainerObservatory getContainer() {
        return this.container;
    }

    @Override
    @Nonnull
    protected List<ConstellationDiscoveryScreen.DrawArea> createDrawAreas() {
        return Lists.newArrayList((Object[])new ConstellationDiscoveryScreen.DrawArea[]{FullScreenDrawArea.INSTANCE});
    }

    @Override
    protected void fillConstellations(WorldContext ctx, List<ConstellationDiscoveryScreen.DrawArea> drawAreas) {
        ConstellationDiscoveryScreen.DrawArea area = drawAreas.get(0);
        Random gen = ctx.getDayRandom();
        HashMap<IConstellation, Point2D.Float> placed = new HashMap<IConstellation, Point2D.Float>();
        for (IConstellation cst : ctx.getActiveCelestialsHandler().getActiveConstellations()) {
            Point2D.Float foundPoint;
            while ((foundPoint = this.tryEmptyPlace(placed.values(), gen)) == null) {
            }
            area.addConstellationToArea(cst, new PlayerAngledConstellationInformation(150.0f, foundPoint.y, foundPoint.x));
            placed.put(cst, foundPoint);
        }
        for (int i = 0; i < 220; ++i) {
            this.usedStars.add(new Point2D.Float(16.0f + gen.nextFloat() * (float)this.getGuiWidth(), 16.0f + gen.nextFloat() * (float)this.getGuiHeight()));
        }
    }

    private Point2D.Float tryEmptyPlace(Collection<Point2D.Float> placed, Random gen) {
        double constellationGap = 12.0;
        constellationGap = Math.sqrt(constellationGap * constellationGap * 2.0);
        float rPitch = -25.0f + gen.nextFloat() * -50.0f;
        float rYaw = gen.nextFloat() * 360.0f;
        for (Point2D.Float point : placed) {
            if (!(point.distance(rPitch, rYaw) <= constellationGap) && !(point.distance(rPitch, rYaw - 360.0f) <= constellationGap)) continue;
            return null;
        }
        return new Point2D.Float(rPitch, rYaw);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        EventFlags.GUI_CLOSING.executeWithFlag(() -> Minecraft.func_71410_x().field_71439_g.func_71053_j());
    }

    @Override
    public void func_230430_a_(MatrixStack renderStack, int mouseX, int mouseY, float pTicks) {
        RenderSystem.enableDepthTest();
        super.func_230430_a_(renderStack, mouseX, mouseY, pTicks);
        Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
        double guiFactor = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)MathHelper.func_76128_c((double)(14.0 * guiFactor)), (int)MathHelper.func_76128_c((double)(14.0 * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.getGuiWidth() + 2) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.getGuiHeight() + 2) * guiFactor)));
        this.drawObservatoryScreen(renderStack, pTicks);
        GL11.glDisable((int)3089);
        this.drawFrame(renderStack);
    }

    private void drawObservatoryScreen(MatrixStack renderStack, float pTicks) {
        boolean canSeeSky = this.canObserverSeeSky(((TileObservatory)this.getTile()).func_174877_v(), 2);
        double guiFactor = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        float pitch = Minecraft.func_71410_x().field_71439_g.func_195050_f(pTicks);
        float angleOpacity = 0.0f;
        if (pitch < -30.0f) {
            angleOpacity = 1.0f;
        } else if (pitch <= -9.0f) {
            angleOpacity = 0.2f + 0.8f * ((Math.abs(pitch) - 10.0f) / 20.0f);
            angleOpacity = MathHelper.func_76129_c((float)angleOpacity);
        }
        float brMultiplier = angleOpacity;
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        this.func_230926_e_(-10);
        this.drawSkyBackground(renderStack, pTicks, canSeeSky, angleOpacity);
        if (!this.isInitialized()) {
            this.func_230926_e_(0);
            Blending.DEFAULT.apply();
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            return;
        }
        float playerYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z % 360.0f;
        if (playerYaw < 0.0f) {
            playerYaw += 360.0f;
        }
        if (playerYaw >= 180.0f) {
            playerYaw -= 360.0f;
        }
        float playerPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        float rainBr = 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(pTicks);
        WorldContext ctx = SkyHandler.getContext((World)Minecraft.func_71410_x().field_71441_e, LogicalSide.CLIENT);
        if (ctx != null && canSeeSky) {
            Random gen = ctx.getDayRandom();
            this.func_230926_e_(-9);
            TexturesAS.TEX_STAR_1.bindTexture();
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
                for (Point2D.Float star : this.usedStars) {
                    float size = 3.0f + gen.nextFloat() * 3.0f;
                    float brightness = 0.4f + RenderingConstellationUtils.stdFlicker(ClientScheduler.getClientTick(), pTicks, 10 + gen.nextInt(20)) * 0.5f;
                    brightness = this.multiplyStarBrightness(pTicks, brightness);
                    RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(16.0f + star.x, 16.0f + star.y).dim(size, size).color(brightness *= brMultiplier, brightness, brightness, brightness).draw();
                }
            });
            this.func_230926_e_(-7);
            for (ConstellationDiscoveryScreen.DrawArea area : this.getVisibleDrawAreas()) {
                for (IConstellation cst : area.getDisplayMap().keySet()) {
                    ConstellationDiscoveryScreen.ConstellationDisplayInformation info = area.getDisplayMap().get(cst);
                    info.getFrameDrawInformation().clear();
                    if (!(info instanceof PlayerAngledConstellationInformation)) continue;
                    PlayerAngledConstellationInformation cstInfo = (PlayerAngledConstellationInformation)info;
                    float size = cstInfo.getRenderSize();
                    float diffYaw = playerYaw - cstInfo.getYaw();
                    float diffPitch = playerPitch - cstInfo.getPitch();
                    if (!(Math.abs(diffYaw) <= size)) {
                        float f;
                        diffYaw += 360.0f;
                        if (!(Math.abs(f) <= size)) continue;
                    }
                    if (!(Math.abs(diffPitch) <= size)) continue;
                    int wPart = MathHelper.func_76141_d((float)((float)this.getGuiWidth() * 0.1f));
                    int hPart = MathHelper.func_76141_d((float)((float)this.getGuiHeight() * 0.1f));
                    float xFactor = diffYaw / 8.0f;
                    float yFactor = diffPitch / 8.0f;
                    Map<StarLocation, Rectangle2D.Float> cstRenderInfo = RenderingConstellationUtils.renderConstellationIntoGUI(cst, renderStack, this.getGuiLeft() + wPart + MathHelper.func_76128_c((double)((double)xFactor / guiFactor * (double)this.getGuiWidth())), this.getGuiTop() + hPart + MathHelper.func_76128_c((double)((double)yFactor / guiFactor * (double)this.getGuiHeight())), this.getGuiZLevel(), MathHelper.func_76141_d((float)((float)this.getGuiHeight() * 0.6f)), MathHelper.func_76141_d((float)((float)this.getGuiHeight() * 0.6f)), 2.0, () -> Float.valueOf((0.2f + 0.7f * RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), pTicks, 5 + gen.nextInt(15)) * rainBr) * brMultiplier), ResearchHelper.getClientProgress().hasConstellationDiscovered(cst), true);
                    cstInfo.getFrameDrawInformation().putAll(cstRenderInfo);
                }
            }
            this.func_230926_e_(-5);
            this.renderDrawnLines(renderStack, gen, pTicks);
        }
        this.func_230926_e_(0);
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    private void drawFrame(MatrixStack renderStack) {
        this.func_230926_e_(10);
        TexturesAS.TEX_GUI_OBSERVATORY.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(0.0f, 0.0f).dim(16.0f, 16.0f).tex(0.0f, 0.0f, 0.4f, 0.4f).draw();
            RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(this.getGuiWidth() + 16, 0.0f).dim(16.0f, 16.0f).tex(0.4f, 0.0f, 0.4f, 0.4f).draw();
            RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(this.getGuiWidth() + 16, this.getGuiHeight() + 16).dim(16.0f, 16.0f).tex(0.4f, 0.4f, 0.4f, 0.4f).draw();
            RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(0.0f, this.getGuiHeight() + 16).dim(16.0f, 16.0f).tex(0.0f, 0.4f, 0.4f, 0.4f).draw();
            RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(16.0f, 0.0f).dim(this.getGuiWidth(), 16.0f).tex(0.8f, 0.0f, 0.05f, 0.4f).draw();
            RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(this.getGuiWidth() + 16, 16.0f).dim(16.0f, this.getGuiHeight()).tex(0.0f, 0.85f, 0.4f, 0.05f).draw();
            RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(16.0f, this.getGuiHeight() + 16).dim(this.getGuiWidth(), 16.0f).tex(0.85f, 0.0f, 0.05f, 0.4f).draw();
            RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).at(0.0f, 16.0f).dim(16.0f, this.getGuiHeight()).tex(0.0f, 0.8f, 0.4f, 0.05f).draw();
        });
        this.func_230926_e_(0);
    }

    private void drawSkyBackground(MatrixStack renderStack, float pTicks, boolean canSeeSky, float angleOpacity) {
        Tuple<Color, Color> rgbFromTo = SkyScreen.getSkyGradient(canSeeSky, angleOpacity, pTicks);
        RenderingDrawUtils.drawGradientRect(renderStack, this.getGuiZLevel(), this.guiLeft, this.guiTop, this.guiLeft + this.guiWidth, this.guiTop + this.guiHeight, ((Color)rgbFromTo.func_76341_a()).getRGB(), ((Color)rgbFromTo.func_76340_b()).getRGB());
    }

    public void func_212927_b(double xPos, double yPos) {
        if (!Minecraft.func_71410_x().field_71417_B.func_198035_h()) {
            return;
        }
        int offsetX = 6;
        int offsetY = 6;
        int width = this.guiWidth - 12;
        int height = this.guiHeight - 12;
        Minecraft mc = Minecraft.func_71410_x();
        double xDiff = mc.field_71417_B.func_198024_e() - xPos / ((double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
        double yDiff = mc.field_71417_B.func_198026_f() - yPos / ((double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
        float pitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        if (pitch <= -89.99f && yDiff > 0.0) {
            yDiff = 0.0;
        }
        if (pitch >= -10.0f) {
            Minecraft.func_71410_x().field_71439_g.field_70125_A = -10.0f;
            yDiff = 0.0;
        }
        if (pitch <= -75.0f) {
            Minecraft.func_71410_x().field_71439_g.field_70125_A = -75.0f;
            yDiff = 0.0;
        }
        for (Point2D.Float sl : this.usedStars) {
            sl.x = (float)((double)sl.x - xDiff);
            sl.y = (float)((double)sl.y + yDiff);
            if (sl.x < (float)offsetX) {
                sl.x += (float)width;
            } else if (sl.x > (float)(offsetX + width)) {
                sl.x -= (float)width;
            }
            if (sl.y < (float)offsetY) {
                sl.y += (float)height;
                continue;
            }
            if (!(sl.y > (float)(offsetY + height))) continue;
            sl.y -= (float)height;
        }
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        return true;
    }
}

