/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.resource.query;

import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.resource.query.TextureQuery;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpriteQuery
extends TextureQuery {
    private final int rows;
    private final int columns;
    private Object spriteResource;

    public SpriteQuery(AssetLoader.TextureLocation location, int rows, int columns, String ... path) {
        super(location, path);
        this.rows = rows;
        this.columns = columns;
    }

    private SpriteQuery(Object spriteResource, int rows, int columns) {
        super(null, "");
        this.spriteResource = spriteResource;
        this.rows = rows;
        this.columns = columns;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SpriteQuery of(SpriteSheetResource res) {
        return new SpriteQuery(res, res.getRows(), res.getColumns());
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public SpriteSheetResource resolveSprite() {
        if (this.spriteResource == null) {
            AbstractRenderableTexture res = this.resolve();
            this.spriteResource = new SpriteSheetResource(res, this.getRows(), this.getColumns());
        }
        return (SpriteSheetResource)this.spriteResource;
    }
}

