/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.resource;

import hellfirepvp.astralsorcery.client.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.obj.WavefrontObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AssetLoader {
    private AssetLoader() {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static BindableResource load(AssetLocation location, SubLocation subLocation, String name, String suffix) {
        return new BindableResource(AssetLoader.buildResourceString(location, subLocation, name, suffix));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String buildResourceString(AssetLocation location, SubLocation subLocation, String name, String suffix) {
        if (name.endsWith(suffix)) {
            name = name.substring(0, name.length() - suffix.length());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("astralsorcery").append(':').append(location.location).append("/");
        if (subLocation != null) {
            builder.append(subLocation.getLocation()).append("/");
        }
        builder.append(name).append(suffix);
        return builder.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static BindableResource loadTexture(TextureLocation location, String name) {
        return AssetLoader.load(AssetLocation.TEXTURES, location, name, ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static WavefrontObject loadObjModel(ModelLocation location, String name) {
        return new WavefrontObject(new ResourceLocation(AssetLoader.buildResourceString(AssetLocation.MODELS, location, name, ".obj")));
    }

    public static enum AssetLocation {
        MODELS("models"),
        TEXTURES("textures");

        private final String location;

        private AssetLocation(String location) {
            this.location = location;
        }
    }

    public static enum TextureLocation implements SubLocation
    {
        ITEMS("item"),
        BLOCKS("block"),
        GUI("gui"),
        MISC("misc"),
        MODEL("model"),
        EFFECT("effect"),
        ENVIRONMENT("environment"),
        CONSTELLATION("constellation");

        private final String location;

        private TextureLocation(String location) {
            this.location = location;
        }

        @Override
        public String getLocation() {
            return this.location;
        }
    }

    public static enum ModelLocation implements SubLocation
    {
        OBJ("obj");

        private final String location;

        private ModelLocation(String location) {
            this.location = location;
        }

        @Override
        public String getLocation() {
            return this.location;
        }
    }

    public static interface SubLocation {
        public String getLocation();
    }
}

