/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.resource;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.resource.BindableResource;
import hellfirepvp.astralsorcery.client.sky.astral.AstralSkyRenderer;
import hellfirepvp.astralsorcery.common.util.object.CacheReference;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class AssetLibrary
implements ISelectiveResourceReloadListener {
    public static AssetLibrary INSTANCE = new AssetLibrary();
    private static boolean reloading = false;
    private static Map<AssetLoader.SubLocation, Map<String, BindableResource>> loadedTextures = new HashMap<AssetLoader.SubLocation, Map<String, BindableResource>>();

    private AssetLibrary() {
    }

    public static Supplier<AbstractRenderableTexture> loadReference(AssetLoader.TextureLocation location, String ... path) {
        return new CacheReference<AbstractRenderableTexture>(() -> AssetLibrary.loadTexture(location, path));
    }

    public static AbstractRenderableTexture loadTexture(AssetLoader.TextureLocation location, String ... path) {
        String name = String.join((CharSequence)"/", path);
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException("Tried to loadTexture with appended .png from the AssetLibrary!");
        }
        return loadedTextures.computeIfAbsent(location, l -> new HashMap()).computeIfAbsent(name, str -> AssetLoader.loadTexture(location, str));
    }

    public static boolean isReloading() {
        return reloading;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (reloading || !resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            return;
        }
        reloading = true;
        AstralSorcery.log.info("[AssetLibrary] Refreshing and Invalidating Resources");
        for (Map<String, BindableResource> map : loadedTextures.values()) {
            map.values().forEach(BindableResource::invalidateAndReload);
        }
        reloading = false;
        AstralSkyRenderer.INSTANCE.reset();
        AstralSorcery.log.info("[AssetLibrary] Successfully reloaded library.");
    }
}

