/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.vfx;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Matrix4f;

public class FXLightbeam
extends EntityVisualFX {
    private Vector3 from;
    private Vector3 to;
    private Vector3 aim;
    private Vector3 aimPerp;
    private double fromSize;
    private double toSize;

    public FXLightbeam(Vector3 pos) {
        super(pos);
        this.from = pos;
    }

    public FXLightbeam setup(Vector3 to, double fromSize, double toSize) {
        this.to = to;
        this.aim = to.clone().subtract(this.getPosition());
        this.aimPerp = this.aim.clone().perpendicular().normalize();
        this.fromSize = fromSize;
        this.toSize = toSize;
        return this;
    }

    @Override
    public <T extends EntityVisualFX> void render(BatchRenderContext<T> ctx, MatrixStack renderStack, IVertexBuilder vb, float pTicks) {
        Color c = this.getColor(pTicks);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = this.getAlpha(pTicks);
        float scale = this.getScale(pTicks);
        Vector3 renderOffset = RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks);
        this.renderCurrentTextureAroundAxis(vb, renderStack, ctx, renderOffset, Math.toRadians(0.0), scale, r, g, b, a);
        this.renderCurrentTextureAroundAxis(vb, renderStack, ctx, renderOffset, Math.toRadians(120.0), scale, r, g, b, a);
        this.renderCurrentTextureAroundAxis(vb, renderStack, ctx, renderOffset, Math.toRadians(240.0), scale, r, g, b, a);
    }

    private <T extends EntityVisualFX> void renderCurrentTextureAroundAxis(IVertexBuilder vb, MatrixStack renderStack, BatchRenderContext<T> ctx, Vector3 renderOffset, double angle, float scale, int r, int g, int b, int a) {
        Vector3 perp = this.aimPerp.clone().rotate(angle, this.aim).normalize();
        Vector3 perpTo = perp.clone().multiply(this.toSize * (double)scale);
        Vector3 perpFrom = perp.multiply(this.fromSize * (double)scale);
        SpriteSheetResource ssr = ctx.getSprite();
        Tuple<Float, Float> uvOffset = ssr.getUVOffset(this.age);
        float u = ((Float)uvOffset.func_76341_a()).floatValue();
        float v = ((Float)uvOffset.func_76340_b()).floatValue();
        float uWidth = ssr.getULength();
        float vHeight = ssr.getVLength();
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        Vector3 vec = this.to.clone().add(perpTo.clone().multiply(-1)).subtract(renderOffset);
        vec.drawPos(matr, vb).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vHeight).func_181675_d();
        vec = this.to.clone().add(perpTo).subtract(renderOffset);
        vec.drawPos(matr, vb).func_225586_a_(r, g, b, a).func_225583_a_(u + uWidth, v + vHeight).func_181675_d();
        vec = this.from.clone().add(perpFrom).subtract(renderOffset);
        vec.drawPos(matr, vb).func_225586_a_(r, g, b, a).func_225583_a_(u + uWidth, v).func_181675_d();
        vec = this.from.clone().add(perpFrom.clone().multiply(-1)).subtract(renderOffset);
        vec.drawPos(matr, vb).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_181675_d();
    }
}

