/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village;

import java.io.File;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Effect;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.village.VillageModuleClient;
import shadows.apotheosis.village.fletching.BlockFletchingTable;
import shadows.apotheosis.village.fletching.FletchingContainer;
import shadows.apotheosis.village.fletching.FletchingRecipe;
import shadows.apotheosis.village.fletching.arrows.BroadheadArrowEntity;
import shadows.apotheosis.village.fletching.arrows.BroadheadArrowItem;
import shadows.apotheosis.village.fletching.arrows.ExplosiveArrowEntity;
import shadows.apotheosis.village.fletching.arrows.ExplosiveArrowItem;
import shadows.apotheosis.village.fletching.arrows.MiningArrowEntity;
import shadows.apotheosis.village.fletching.arrows.MiningArrowItem;
import shadows.apotheosis.village.fletching.arrows.ObsidianArrowEntity;
import shadows.apotheosis.village.fletching.arrows.ObsidianArrowItem;
import shadows.apotheosis.village.fletching.effects.BleedingEffect;
import shadows.apotheosis.village.wanderer.WandererReplacements;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;

public class VillageModule {
    public static final IRecipeType<FletchingRecipe> FLETCHING = IRecipeType.func_222147_a((String)"apotheosis:fletching");
    public static final IRecipeSerializer<FletchingRecipe> FLETCHING_SERIALIZER = new FletchingRecipe.Serializer();
    public static Configuration config;
    public static boolean enableNewTrades;

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        MinecraftForge.EVENT_BUS.addListener(WandererReplacements::replaceWandererArrays);
        MinecraftForge.EVENT_BUS.addListener(ApotheosisObjects.OBSIDIAN_ARROW::handleArrowJoin);
        Map types = (Map)ObfuscationReflectionHelper.getPrivateValue(PointOfInterestType.class, null, (String)"field_221073_u");
        types.put(Blocks.field_222426_lO.func_176223_P(), PointOfInterestType.field_221061_i);
        config = new Configuration(new File(Apotheosis.configDir, "village.cfg"));
        enableNewTrades = config.getBoolean("Enable New Trades", "Wanderer", true, "If new trades are added to the wandering merchant.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void setup(FMLClientSetupEvent e) {
        e.enqueueWork(VillageModuleClient::init);
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)FLETCHING_SERIALIZER.setRegistryName(FletchingRecipe.Serializer.NAME));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        PlaceboUtil.registerOverrideBlock((Block)new BlockFletchingTable(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ObsidianArrowItem().setRegistryName("obsidian_arrow"), (Item)new BroadheadArrowItem().setRegistryName("broadhead_arrow"), (Item)new ExplosiveArrowItem().setRegistryName("explosive_arrow"), (Item)new MiningArrowItem(() -> Items.field_151035_b, MiningArrowEntity.Type.IRON).setRegistryName("iron_mining_arrow"), (Item)new MiningArrowItem(() -> Items.field_151046_w, MiningArrowEntity.Type.DIAMOND).setRegistryName("diamond_mining_arrow")});
    }

    @SubscribeEvent
    public void entities(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().register(EntityType.Builder.func_220322_a(ObsidianArrowEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).func_220321_a(0.5f, 0.5f).setCustomClientFactory((se, w) -> new ObsidianArrowEntity((World)w)).func_206830_a("ob_arrow").setRegistryName("ob_arrow_entity"));
        e.getRegistry().register(EntityType.Builder.func_220322_a(BroadheadArrowEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).func_220321_a(0.5f, 0.5f).setCustomClientFactory((se, w) -> new BroadheadArrowEntity((World)w)).func_206830_a("bh_arrow").setRegistryName("bh_arrow_entity"));
        e.getRegistry().register(EntityType.Builder.func_220322_a(ExplosiveArrowEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).func_220321_a(0.5f, 0.5f).setCustomClientFactory((se, w) -> new ExplosiveArrowEntity((World)w)).func_206830_a("ex_arrow").setRegistryName("ex_arrow_entity"));
        e.getRegistry().register(EntityType.Builder.func_220322_a(MiningArrowEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).func_220321_a(0.5f, 0.5f).setCustomClientFactory((se, w) -> new MiningArrowEntity((World)w)).func_206830_a("mn_arrow").setRegistryName("mn_arrow_entity"));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<ContainerType<?>> e) {
        e.getRegistry().register(new ContainerType(FletchingContainer::new).setRegistryName("fletching"));
    }

    @SubscribeEvent
    public void effects(RegistryEvent.Register<Effect> e) {
        e.getRegistry().register(new BleedingEffect().setRegistryName("bleeding"));
    }

    static {
        enableNewTrades = true;
    }
}

