/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.spawner;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.spawn.SpawnerModifiers;
import shadows.apotheosis.spawn.SpawnerModule;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;

public class ApothSpawnerBlock
extends SpawnerBlock {
    public ApothSpawnerBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.setRegistryName("minecraft", "spawner");
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack s = new ItemStack((IItemProvider)this);
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            te.func_189515_b(s.func_190925_c("BlockEntityTag"));
        }
        return s;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            te.func_230337_a_(state, stack.func_190925_c("BlockEntityTag"));
            te.func_174878_a(pos);
        }
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        if (SpawnerModule.spawnerSilkLevel != -1 && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) >= SpawnerModule.spawnerSilkLevel) {
            ItemStack s = new ItemStack((IItemProvider)this);
            if (te != null) {
                te.func_189515_b(s.func_190925_c("BlockEntityTag"));
            }
            ApothSpawnerBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s);
            player.func_184614_ca().func_222118_a(SpawnerModule.spawnerSilkDamage, (LivingEntity)player, pl -> pl.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        this.func_176208_a(world, pos, state, player);
        if (player.func_184812_l_()) {
            return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        }
        return willHarvest;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ApothSpawnerTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ApothSpawnerTile) {
            ApothSpawnerTile tile = (ApothSpawnerTile)te;
            boolean inverse = SpawnerModifiers.inverseItem.test(player.func_184586_b(hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND));
            for (SpawnerModifier sm : SpawnerModifiers.MODIFIERS) {
                if (!sm.canModify(tile, stack, inverse)) continue;
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                if (!sm.modify(tile, stack, inverse)) continue;
                if (!player.func_184812_l_() && !(stack.func_77973_b() instanceof SpawnEggItem)) {
                    stack.func_190918_g(1);
                }
                AdvancementTriggers.SPAWNER_MODIFIER.trigger((ServerPlayerEntity)player, tile, sm);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("BlockEntityTag", 10)) {
            CompoundNBT tag = stack.func_77978_p().func_74775_l("BlockEntityTag");
            if (tag.func_74764_b("SpawnData")) {
                tooltip.add(this.grayTranslated("info.spw.entity", tag.func_74775_l("SpawnData").func_74779_i("id")));
            }
            if (tag.func_74764_b("MinSpawnDelay")) {
                tooltip.add(this.grayTranslated("waila.spw.mindelay", tag.func_74765_d("MinSpawnDelay")));
            }
            if (tag.func_74764_b("MaxSpawnDelay")) {
                tooltip.add(this.grayTranslated("waila.spw.maxdelay", tag.func_74765_d("MaxSpawnDelay")));
            }
            if (tag.func_74764_b("SpawnCount")) {
                tooltip.add(this.grayTranslated("waila.spw.spawncount", tag.func_74765_d("SpawnCount")));
            }
            if (tag.func_74764_b("MaxNearbyEntities")) {
                tooltip.add(this.grayTranslated("waila.spw.maxnearby", tag.func_74765_d("MaxNearbyEntities")));
            }
            if (tag.func_74764_b("RequiredPlayerRange")) {
                tooltip.add(this.grayTranslated("waila.spw.playerrange", tag.func_74765_d("RequiredPlayerRange")));
            }
            if (tag.func_74764_b("SpawnRange")) {
                tooltip.add(this.grayTranslated("waila.spw.spawnrange", tag.func_74765_d("SpawnRange")));
            }
            if (tag.func_74767_n("ignore_players")) {
                tooltip.add(this.grayTranslated("waila.spw.ignoreplayers", new Object[0]));
            }
            if (tag.func_74767_n("ignore_conditions")) {
                tooltip.add(this.grayTranslated("waila.spw.ignoreconditions", new Object[0]));
            }
            if (tag.func_74767_n("ignore_cap")) {
                tooltip.add(this.grayTranslated("waila.spw.ignorecap", new Object[0]));
            }
            if (tag.func_74767_n("redstone_control")) {
                tooltip.add(this.grayTranslated("waila.spw.redstone", new Object[0]));
            }
        }
    }

    private ITextComponent grayTranslated(String s, Object ... args) {
        return new TranslationTextComponent(s, args).func_240699_a_(TextFormatting.GRAY);
    }

    public Item func_199767_j() {
        return Items.field_221671_bX;
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? super.getExpDrop(state, world, pos, fortune, silktouch) : 0;
    }
}

