/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.spawn.SpawnerModifiers;
import shadows.apotheosis.spawn.enchantment.CapturingEnchant;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.spawner.ApothSpawnerBlock;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;

public class SpawnerModule {
    public static final Logger LOG = LogManager.getLogger((String)"Apotheosis : Spawner");
    public static int spawnerSilkLevel = 1;
    public static int spawnerSilkDamage = 100;

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        TileEntityType.field_200979_j.field_200995_z = ApothSpawnerTile::new;
        TileEntityType.field_200979_j.field_223046_I = ImmutableSet.of((Object)Blocks.field_150474_ac);
        MinecraftForge.EVENT_BUS.addListener(this::handleCapturing);
        MinecraftForge.EVENT_BUS.addListener(this::handleUseItem);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        SpawnerModifiers.registerModifiers();
        this.reload(null);
        ObfuscationReflectionHelper.setPrivateValue(Item.class, (Object)Items.field_221671_bX, (Object)ItemGroup.field_78026_f, (String)"field_77701_a");
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        PlaceboUtil.registerOverrideBlock((Block)new ApothSpawnerBlock(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().register(new CapturingEnchant().setRegistryName("apotheosis", "capturing"));
    }

    public void handleCapturing(LivingDropsEvent e) {
        Entity killer = e.getSource().func_76346_g();
        if (killer instanceof LivingEntity) {
            int level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.CAPTURING, (ItemStack)((LivingEntity)killer).func_184614_ca());
            if (e.getEntityLiving().field_70170_p.field_73012_v.nextFloat() < (float)level / 250.0f) {
                LivingEntity killed = e.getEntityLiving();
                ItemStack egg = new ItemStack((IItemProvider)SpawnEggItem.field_195987_b.get(killed.func_200600_R()));
                e.getDrops().add(new ItemEntity(killed.field_70170_p, killed.func_226277_ct_(), killed.func_226278_cu_(), killed.func_226281_cx_(), egg));
            }
        }
    }

    public void handleUseItem(PlayerInteractEvent.RightClickBlock e) {
        TileEntity te = e.getWorld().func_175625_s(e.getPos());
        if (te instanceof ApothSpawnerTile) {
            ItemStack s = e.getItemStack();
            if (e.getPlayer().func_225608_bj_() && s.func_77973_b() instanceof SpawnEggItem && SpawnerModifiers.EGG.modify((ApothSpawnerTile)te, s, false)) {
                e.setCanceled(true);
                return;
            }
            boolean inverse = SpawnerModifiers.inverseItem.test(e.getPlayer().func_184586_b(e.getHand() == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND));
            for (SpawnerModifier sm : SpawnerModifiers.MODIFIERS) {
                if (!sm.canModify((ApothSpawnerTile)te, s, inverse)) continue;
                e.setUseBlock(Event.Result.ALLOW);
            }
        }
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration config = new Configuration(new File(Apotheosis.configDir, "spawner.cfg"));
        spawnerSilkLevel = config.getInt("Spawner Silk Level", "general", 1, -1, 127, "The level of silk touch needed to harvest a spawner.  Set to -1 to disable, 0 to always drop.  The enchantment module can increase the max level of silk touch.");
        spawnerSilkDamage = config.getInt("Spawner Silk Damage", "general", 100, 0, 100000, "The durability damage dealt to an item that silk touches a spawner.");
        SpawnerModifiers.reload(config);
        if (e == null && config.hasChanged()) {
            config.save();
        }
    }
}

