/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import shadows.apotheosis.ApotheosisObjects;

public class PotionCharmRecipe
extends ShapedRecipe {
    public PotionCharmRecipe() {
        super(new ResourceLocation("apotheosis", "potion_charm"), "", 3, 3, PotionCharmRecipe.makeIngredients(), new ItemStack((IItemProvider)ApotheosisObjects.POTION_CHARM));
    }

    private static NonNullList<Ingredient> makeIngredients() {
        Ingredient blaze = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151065_br)});
        ArrayList<ItemStack> potionStacks = new ArrayList<ItemStack>();
        for (Potion p : ForgeRegistries.POTION_TYPES) {
            if (p.func_185170_a().size() != 1 || ((EffectInstance)p.func_185170_a().get(0)).func_188419_a().func_76403_b()) continue;
            ItemStack potion = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)potion, (Potion)p);
            potionStacks.add(potion);
        }
        Ingredient potion = Ingredient.func_193369_a((ItemStack[])potionStacks.toArray(new ItemStack[0]));
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{blaze, blaze, blaze, potion, potion, potion, blaze, blaze, blaze});
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack out = super.func_77572_b(inv);
        PotionUtils.func_185188_a((ItemStack)out, (Potion)PotionUtils.func_185191_c((ItemStack)inv.func_70301_a(4)));
        return out;
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        if (super.func_77569_a(inv, world)) {
            Potion left = PotionUtils.func_185191_c((ItemStack)inv.func_70301_a(3));
            Potion mid = PotionUtils.func_185191_c((ItemStack)inv.func_70301_a(4));
            Potion right = PotionUtils.func_185191_c((ItemStack)inv.func_70301_a(5));
            if (left != null && mid != null && right != null) {
                if (mid.func_185170_a().size() != 1 || ((EffectInstance)mid.func_185170_a().get(0)).func_188419_a().func_76403_b()) {
                    return false;
                }
                return left.getRegistryName().equals((Object)mid.getRegistryName()) && mid.getRegistryName().equals((Object)right.getRegistryName());
            }
        }
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PotionCharmRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public PotionCharmRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new PotionCharmRecipe();
        }

        public PotionCharmRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new PotionCharmRecipe();
        }

        public void write(PacketBuffer buffer, PotionCharmRecipe recipe) {
        }
    }
}

