/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionCharmItem
extends Item {
    public PotionCharmItem() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(192).func_200916_a(ItemGroup.field_78026_f));
    }

    public ItemStack func_190903_i() {
        return PotionUtils.func_185188_a((ItemStack)super.func_190903_i(), (Potion)Potions.field_185237_i);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        Potion p;
        EffectInstance contained;
        EffectInstance active;
        if (!PotionCharmItem.hasPotion(stack)) {
            return;
        }
        if (stack.func_196082_o().func_74767_n("charm_enabled") && entity instanceof ServerPlayerEntity && ((active = ((ServerPlayerEntity)entity).func_70660_b((contained = (EffectInstance)(p = PotionUtils.func_185191_c((ItemStack)stack)).func_185170_a().get(0)).func_188419_a())) == null || active.func_76459_b() < (active.func_188419_a() == Effects.field_76439_r ? 210 : 5))) {
            int durationOffset;
            int n = durationOffset = contained.func_188419_a() == Effects.field_76439_r ? 210 : 5;
            if (contained.func_188419_a() == Effects.field_76428_l) {
                durationOffset += 50 >> contained.func_76458_c();
            }
            EffectInstance newEffect = new EffectInstance(contained.func_188419_a(), (int)Math.ceil((double)contained.func_76459_b() / 24.0) + durationOffset, contained.func_76458_c(), false, false);
            ((ServerPlayerEntity)entity).func_195064_c(newEffect);
            if (stack.func_96631_a(contained.func_188419_a() == Effects.field_76428_l ? 2 : 1, world.field_73012_v, (ServerPlayerEntity)entity)) {
                stack.func_190918_g(1);
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("charm_enabled");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            stack.func_196082_o().func_74757_a("charm_enabled", !stack.func_77978_p().func_74767_n("charm_enabled"));
        } else if (!stack.func_77978_p().func_74767_n("charm_enabled")) {
            world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 0.3f);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (PotionCharmItem.hasPotion(stack)) {
            Potion p = PotionUtils.func_185191_c((ItemStack)stack);
            EffectInstance effect = (EffectInstance)p.func_185170_a().get(0);
            TranslationTextComponent potionCmp = new TranslationTextComponent(effect.func_76453_d());
            if (effect.func_76458_c() > 0) {
                potionCmp = new TranslationTextComponent("potion.withAmplifier", new Object[]{potionCmp, new TranslationTextComponent("potion.potency." + effect.func_76458_c())});
            }
            potionCmp.func_240699_a_(effect.func_188419_a().func_220303_e().func_220306_a());
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".desc", new Object[]{potionCmp}).func_240699_a_(TextFormatting.GRAY));
            boolean enabled = stack.func_196082_o().func_74767_n("charm_enabled");
            TranslationTextComponent enabledCmp = new TranslationTextComponent(this.func_77658_a() + (enabled ? ".enabled" : ".disabled"));
            enabledCmp.func_240699_a_(enabled ? TextFormatting.BLUE : TextFormatting.RED);
            if (effect.func_76459_b() > 20) {
                potionCmp = new TranslationTextComponent("potion.withDuration", new Object[]{potionCmp, EffectUtils.func_188410_a((EffectInstance)effect, (float)1.0f)});
            }
            potionCmp.func_240699_a_(effect.func_188419_a().func_220303_e().func_220306_a());
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".desc3", new Object[]{potionCmp}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        if (!PotionCharmItem.hasPotion(stack)) {
            return 1;
        }
        return 192;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (!PotionCharmItem.hasPotion(stack)) {
            return new TranslationTextComponent("item.apotheosis.potion_charm_broke");
        }
        Potion p = PotionUtils.func_185191_c((ItemStack)stack);
        EffectInstance effect = (EffectInstance)p.func_185170_a().get(0);
        TranslationTextComponent potionCmp = new TranslationTextComponent(effect.func_76453_d());
        if (effect.func_76458_c() > 0) {
            potionCmp = new TranslationTextComponent("potion.withAmplifier", new Object[]{potionCmp, new TranslationTextComponent("potion.potency." + effect.func_76458_c())});
        }
        return new TranslationTextComponent("item.apotheosis.potion_charm", new Object[]{potionCmp});
    }

    public static boolean hasPotion(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Potion");
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (Potion potion : ForgeRegistries.POTION_TYPES) {
                if (potion.func_185170_a().size() != 1 || ((EffectInstance)potion.func_185170_a().get(0)).func_188419_a().func_76403_b()) continue;
                items.add((Object)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)this), (Potion)potion));
            }
        }
    }
}

