/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.garden;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderLeashItem
extends Item {
    public EnderLeashItem() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(15).func_200916_a(ItemGroup.field_78026_f));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (stack.func_190925_c("entity_data").isEmpty() && entity instanceof AnimalEntity) {
            CompoundNBT tag = entity.serializeNBT();
            if (!player.field_70170_p.field_72995_K) {
                entity.func_70106_y();
                stack.func_77978_p().func_218657_a("entity_data", (INBT)tag);
                stack.func_77978_p().func_74778_a("name", entity.func_145748_c_().getString());
                this.playSound(player);
            }
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        CompoundNBT tag = ctx.func_195996_i().func_190925_c("entity_data");
        if (!tag.isEmpty()) {
            Entity e;
            BlockPos pos = ctx.func_195995_a().func_177972_a(ctx.func_196000_l());
            if (!ctx.func_195991_k().field_72995_K && (e = EntityType.func_220335_a((CompoundNBT)tag, (World)ctx.func_195991_k(), a -> a)) != null) {
                e.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                ((ServerWorld)ctx.func_195991_k()).func_217440_f(e);
                ctx.func_195996_i().func_77978_p().func_82580_o("entity_data");
                this.playSound(ctx.func_195999_j());
                ctx.func_195996_i().func_222118_a(1, (LivingEntity)ctx.func_195999_j(), pl -> pl.func_213334_d(ctx.func_221531_n()));
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = super.getShareTag(stack);
        if (tag == null) {
            return null;
        }
        tag = tag.func_74737_b();
        CompoundNBT entity = new CompoundNBT();
        if (tag.func_74775_l("entity_data").func_74764_b("id")) {
            entity.func_74778_a("id", tag.func_74775_l("entity_data").func_74779_i("id"));
        }
        tag.func_218657_a("entity_data", (INBT)entity);
        return tag;
    }

    void playSound(PlayerEntity player) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_190925_c("entity_data");
            if (tag.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.apotheosis.noentity"));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.apotheosis.containedentity", new Object[]{stack.func_77978_p().func_74779_i("name")}));
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && !stack.func_190925_c("entity_data").isEmpty();
    }
}

