/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.objects.IEnchantingBlock;
import shadows.placebo.util.NetworkUtils;

public class EnchantingStatManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final EnchantingStatManager INSTANCE = new EnchantingStatManager();
    private final Map<IRegistryDelegate<Block>, Stats> stats = new HashMap<IRegistryDelegate<Block>, Stats>();

    protected EnchantingStatManager() {
        super(GSON, "enchanting_stats");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager mgr, IProfiler profile) {
        this.stats.clear();
        objects.forEach((key, ele) -> {
            try {
                JsonObject obj = (JsonObject)ele;
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(obj.get("block").getAsString()));
                Stats stats = (Stats)GSON.fromJson(obj.get("stats"), Stats.class);
                this.stats.put((IRegistryDelegate<Block>)b.delegate, stats);
            }
            catch (Exception e) {
                EnchModule.LOGGER.error("Failed to read enchantment stat file {}.", key);
                e.printStackTrace();
            }
        });
        EnchModule.LOGGER.info("Registered {} blocks with enchanting stats.", (Object)this.stats.size());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            Apotheosis.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StatSyncMessage(this.stats));
        }
    }

    public static float getEterna(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.stats.containsKey(block.delegate)) {
            return EnchantingStatManager.INSTANCE.stats.get((Object)block.delegate).eterna;
        }
        return state.getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public static float getMaxEterna(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.stats.containsKey(block.delegate)) {
            return EnchantingStatManager.INSTANCE.stats.get((Object)block.delegate).maxEterna;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getMaxEnchantingPower(state, (IWorldReader)world, pos);
        }
        return 15.0f;
    }

    public static float getQuanta(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.stats.containsKey(block.delegate)) {
            return EnchantingStatManager.INSTANCE.stats.get((Object)block.delegate).quanta;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getQuantaBonus(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static float getArcana(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.stats.containsKey(block.delegate)) {
            return EnchantingStatManager.INSTANCE.stats.get((Object)block.delegate).arcana;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getArcanaBonus(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static float getAbsoluteMaxEterna() {
        return EnchantingStatManager.INSTANCE.stats.values().stream().max(Comparator.comparingDouble((ToDoubleFunction<Stats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$getAbsoluteMaxEterna$1(shadows.apotheosis.ench.table.EnchantingStatManager$Stats ), (Lshadows/apotheosis/ench/table/EnchantingStatManager$Stats;)D)())).get().maxEterna;
    }

    public static void dispatch(PlayerEntity player) {
        NetworkUtils.sendTo((SimpleChannel)Apotheosis.CHANNEL, (Object)((Object)new StatSyncMessage(EnchantingStatManager.INSTANCE.stats)), (PlayerEntity)player);
    }

    private static /* synthetic */ double lambda$getAbsoluteMaxEterna$1(Stats s) {
        return s.maxEterna;
    }

    public static class StatSyncMessage
    extends NetworkUtils.MessageProvider<StatSyncMessage> {
        final Map<IRegistryDelegate<Block>, Stats> stats;

        private StatSyncMessage(Map<IRegistryDelegate<Block>, Stats> stats) {
            this.stats = stats;
        }

        public StatSyncMessage() {
            this.stats = new HashMap<IRegistryDelegate<Block>, Stats>();
        }

        public void write(StatSyncMessage msg, PacketBuffer buf) {
            buf.writeShort(msg.stats.size());
            for (Map.Entry<IRegistryDelegate<Block>, Stats> e : msg.stats.entrySet()) {
                buf.writeInt(((ForgeRegistry)ForgeRegistries.BLOCKS).getID((IForgeRegistryEntry)e.getKey().get()));
                Stats stat = e.getValue();
                buf.writeFloat(stat.maxEterna);
                buf.writeFloat(stat.eterna);
                buf.writeFloat(stat.quanta);
                buf.writeFloat(stat.arcana);
            }
        }

        public StatSyncMessage read(PacketBuffer buf) {
            int size = buf.readShort();
            StatSyncMessage pkt = new StatSyncMessage();
            for (int i = 0; i < size; ++i) {
                Block b = (Block)((ForgeRegistry)ForgeRegistries.BLOCKS).getValue(buf.readInt());
                Stats stats = new Stats(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
                pkt.stats.put((IRegistryDelegate<Block>)b.delegate, stats);
            }
            return pkt;
        }

        public void handle(StatSyncMessage msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkUtils.handlePacket(() -> () -> {
                INSTANCE.stats.clear();
                INSTANCE.stats.putAll(msg.stats);
            }, (NetworkEvent.Context)ctx.get());
        }
    }

    public static class Stats {
        final float maxEterna;
        final float eterna;
        final float quanta;
        final float arcana;

        public Stats(float maxEterna, float eterna, float quanta, float arcana) {
            this.maxEterna = maxEterna;
            this.eterna = eterna;
            this.quanta = quanta;
            this.arcana = arcana;
        }
    }
}

