/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.anvil;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.ench.anvil.AnvilTile;

public class ApothAnvilBlock
extends AnvilBlock {
    public ApothAnvilBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151574_g, (MaterialColor)MaterialColor.field_151668_h).func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AnvilTile();
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        ItemStack anvil = new ItemStack((IItemProvider)this);
        if (te instanceof AnvilTile) {
            Object ench = ((AnvilTile)te).getEnchantments();
            ench = ench.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            EnchantmentHelper.func_82782_a(ench, (ItemStack)anvil);
        }
        ApothAnvilBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)anvil);
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof AnvilTile) {
            ((AnvilTile)te).getEnchantments().putAll(EnchantmentHelper.func_82781_a((ItemStack)stack));
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack anvil = new ItemStack((IItemProvider)this);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof AnvilTile) {
            Object ench = ((AnvilTile)te).getEnchantments();
            ench = ench.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            EnchantmentHelper.func_82782_a(ench, (ItemStack)anvil);
        }
        return anvil;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_77962_s()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.apotheosis.anvil").func_240699_a_(TextFormatting.GRAY));
        }
    }

    protected void func_149829_a(FallingBlockEntity e) {
        super.func_149829_a(e);
        TileEntity te = e.field_70170_p.func_175625_s(new BlockPos(e.func_213303_ch()));
        e.field_145810_d = new CompoundNBT();
        if (te instanceof AnvilTile) {
            te.func_189515_b(e.field_145810_d);
        }
    }

    public void func_176502_a_(World world, BlockPos pos, BlockState fallState, BlockState hitState, FallingBlockEntity anvil) {
        super.func_176502_a_(world, pos, fallState, hitState, anvil);
        List items = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
        if (anvil.field_145810_d == null) {
            return;
        }
        Map enchantments = EnchantmentHelper.func_226652_a_((ListNBT)anvil.field_145810_d.func_150295_c("enchantments", 10));
        int oblit = enchantments.getOrDefault(ApotheosisObjects.OBLITERATION, 0);
        int split = enchantments.getOrDefault((Object)ApotheosisObjects.SPLITTING, 0);
        int ub = enchantments.getOrDefault(Enchantments.field_185307_s, 0);
        if (split > 0 || oblit > 0) {
            for (ItemEntity entity : items) {
                ItemStack stack = entity.func_92059_d();
                if (stack.func_77973_b() != Items.field_151134_bR) continue;
                ListNBT enchants = EnchantedBookItem.func_92110_g((ItemStack)stack);
                boolean handled = false;
                if (enchants.size() == 1 && oblit > 0) {
                    handled = this.handleObliteration(world, pos, oblit, entity, enchants);
                } else if (enchants.size() > 1 && split > 0) {
                    handled = this.handleSplitting(world, pos, split, entity, enchants);
                }
                if (!handled) continue;
                if (world.field_73012_v.nextInt(1 + ub) != 0) break;
                BlockState dmg = ApothAnvilBlock.func_196433_f((BlockState)fallState);
                if (dmg == null) {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    world.func_217379_c(1029, pos, 0);
                    break;
                }
                world.func_175656_a(pos, dmg);
                break;
            }
        }
    }

    protected boolean handleSplitting(World world, BlockPos pos, int split, ItemEntity entity, ListNBT enchants) {
        if (world.field_73012_v.nextFloat() < 0.2f * (float)split) {
            entity.func_70106_y();
            for (INBT nbt : enchants) {
                CompoundNBT tag = (CompoundNBT)nbt;
                int level = tag.func_74762_e("lvl");
                Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(tag.func_74779_i("id")));
                ItemStack book = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchant, level));
                Block.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)book);
            }
            world.func_175647_a(ServerPlayerEntity.class, new AxisAlignedBB(pos).func_72314_b(5.0, 5.0, 5.0), EntityPredicates.field_180132_d).forEach(p -> AdvancementTriggers.SPLIT_BOOK.trigger(p.func_192039_O()));
        }
        return true;
    }

    protected boolean handleObliteration(World world, BlockPos pos, int oblit, ItemEntity entity, ListNBT enchants) {
        if (world.field_73012_v.nextFloat() < 0.2f * (float)oblit) {
            CompoundNBT nbt = enchants.func_150305_b(0);
            int level = nbt.func_74762_e("lvl") - 1;
            if (level <= 0) {
                return false;
            }
            Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(nbt.func_74779_i("id")));
            ItemStack book = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchant, level));
            entity.func_70106_y();
            Block.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)book);
            Block.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)book.func_77946_l());
        }
        return true;
    }
}

