/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot;

import java.util.Random;
import net.minecraft.util.text.TextFormatting;

public enum LootRarity {
    COMMON(TextFormatting.GRAY, 1),
    UNCOMMON(TextFormatting.YELLOW, 1),
    RARE(TextFormatting.BLUE, 2),
    EPIC(TextFormatting.RED, 3),
    MYTHIC(TextFormatting.DARK_GREEN, 3),
    ANCIENT(TextFormatting.GOLD, 3);

    final TextFormatting color;
    final int affixes;

    private LootRarity(TextFormatting color, int affixes) {
        this.color = color;
        this.affixes = affixes;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public int getAffixes() {
        return this.affixes;
    }

    public static LootRarity random(Random rand, int min) {
        int range = min + rand.nextInt(1000 - min);
        if (range < 400) {
            return COMMON;
        }
        if (range < 700) {
            return UNCOMMON;
        }
        if (range < 880) {
            return RARE;
        }
        if (range < 950) {
            return EPIC;
        }
        if (range < 1000) {
            return MYTHIC;
        }
        return ANCIENT;
    }

    public static LootRarity random(Random rand) {
        return LootRarity.random(rand, 0);
    }
}

