/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import shadows.apotheosis.deadly.config.DeadlyConstants;
import shadows.apotheosis.deadly.gen.WeightedGenerator;
import shadows.apotheosis.util.SpawnerStats;
import shadows.apotheosis.util.TagBuilder;
import shadows.placebo.util.SpawnerBuilder;

public class SpawnerItem
extends WeightedGenerator.WorldFeatureItem {
    protected final SpawnerBuilder spawner;

    public SpawnerItem(SpawnerBuilder spawner, int weight) {
        super(weight);
        this.spawner = spawner;
    }

    @Override
    public void place(IServerWorld world, BlockPos pos, Random rand) {
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        this.spawner.build((IWorld)world, pos);
    }

    public SpawnerBuilder getSpawner() {
        return this.spawner;
    }

    public static void rebuildItems(List<SpawnerItem> items, SpawnerStats stats, Object2IntMap<ResourceLocation> weightMobPairs) {
        items.clear();
        for (Object2IntMap.Entry pair : weightMobPairs.object2IntEntrySet()) {
            SpawnerBuilder builder = new SpawnerBuilder();
            builder.setType((ResourceLocation)pair.getKey());
            if (((ResourceLocation)pair.getKey()).equals((Object)DeadlyConstants.RANDOM)) {
                builder = TagBuilder.createMobSpawnerRandom();
            }
            stats.apply(builder);
            TagBuilder.checkForSkeleton(builder.getSpawnData());
            items.add(new SpawnerItem(builder, pair.getIntValue()));
        }
    }
}

