/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import io.netty.util.internal.ThreadLocalRandom;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossGenerator;
import shadows.apotheosis.deadly.gen.BrutalSpawnerGenerator;
import shadows.apotheosis.deadly.gen.SwarmSpawnerGenerator;
import shadows.apotheosis.deadly.gen.WeightedGenerator;

public class DeadlyFeature
extends Feature<NoFeatureConfig> {
    public static final List<WeightedGenerator> GENERATORS = new ArrayList<WeightedGenerator>();
    public static final BrutalSpawnerGenerator BRUTAL_SPAWNER = new BrutalSpawnerGenerator();
    public static final BossGenerator BOSS_GENERATOR = new BossGenerator();
    public static final SwarmSpawnerGenerator SWARM_SPAWNER = new SwarmSpawnerGenerator();
    private static final Map<DimensionType, LongSet> SUCCESSES = new HashMap<DimensionType, LongSet>();
    public static final Predicate<BlockState> STONE_TEST = b -> OreFeatureConfig.FillerBlockType.field_241882_a.func_215181_a(b, (Random)ThreadLocalRandom.current());
    public static final ConfiguredFeature<?, ?> INSTANCE = new ConfiguredFeature((Feature)new DeadlyFeature(), (IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final boolean DEBUG = false;

    public DeadlyFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator gen, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!DeadlyConfig.DIM_WHITELIST.contains(world.func_201672_e().func_234923_W_().func_240901_a_())) {
            return false;
        }
        for (WeightedGenerator generator : GENERATORS) {
            ChunkPos cPos = new ChunkPos(pos);
            if (DeadlyFeature.wasSuccess(world.func_230315_m_(), cPos.field_77276_a, cPos.field_77275_b)) {
                return false;
            }
            if (!generator.generate((IServerWorld)world, cPos.field_77276_a, cPos.field_77275_b, rand)) continue;
            return true;
        }
        return false;
    }

    public static void enableGenerators() {
        GENERATORS.clear();
        if (BRUTAL_SPAWNER.isEnabled()) {
            GENERATORS.add(BRUTAL_SPAWNER);
        }
        if (SWARM_SPAWNER.isEnabled()) {
            GENERATORS.add(SWARM_SPAWNER);
        }
        if (BOSS_GENERATOR.isEnabled()) {
            GENERATORS.add(BOSS_GENERATOR);
        }
    }

    public static void debugPillar(World world, BlockPos pos) {
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        mPos.func_189533_g((Vector3i)pos);
        DeadlyModule.LOGGER.info("Marking! " + pos.toString());
        while (mPos.func_177956_o() < 127) {
            world.func_175656_a((BlockPos)mPos.func_181079_c(mPos.func_177958_n(), mPos.func_177956_o() + 1, mPos.func_177952_p()), Blocks.field_150359_w.func_176223_P());
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }

    public static void setSuccess(DimensionType dim, int x, int z) {
        SUCCESSES.computeIfAbsent(dim, i -> new LongOpenHashSet()).add(ChunkPos.func_77272_a((int)x, (int)z));
    }

    public static boolean wasSuccess(DimensionType dim, int x, int z) {
        return SUCCESSES.computeIfAbsent(dim, i -> new LongOpenHashSet()).contains(ChunkPos.func_77272_a((int)x, (int)z));
    }
}

