/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossItem;
import shadows.apotheosis.deadly.gen.DeadlyFeature;
import shadows.apotheosis.deadly.gen.WeightedGenerator;

public class BossGenerator
extends WeightedGenerator {
    public static final List<BossItem> BOSS_ITEMS = new ArrayList<BossItem>();

    @Override
    public boolean generate(IServerWorld world, int chunkX, int chunkZ, Random rand) {
        int y;
        if ((double)DeadlyConfig.bossChance <= rand.nextDouble()) {
            return false;
        }
        int x = (chunkX << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        int z = (chunkZ << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        BlockPos.Mutable mPos = new BlockPos.Mutable(x, y, z);
        BossItem item = (BossItem)WeightedRandom.func_76271_a((Random)rand, BOSS_ITEMS);
        for (y = 15 + rand.nextInt(35); y > 10; --y) {
            if (!Block.func_220055_a((IWorldReader)world, (BlockPos)mPos.func_181079_c(x, y, z), (Direction)Direction.UP) || !world.func_226664_a_(item.getAABB(world).func_186670_a((BlockPos)mPos.func_181079_c(x, y + 1, z)))) continue;
            item.place(world, (BlockPos)mPos, rand);
            DeadlyFeature.setSuccess(world.func_230315_m_(), chunkX, chunkZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBePlaced(IServerWorld world, BlockPos pos, Random rand) {
        return false;
    }

    @Override
    public void place(IServerWorld world, BlockPos pos, Random rand) {
    }

    public static void rebuildBossItems() {
        BOSS_ITEMS.clear();
        for (Object2IntMap.Entry pair : DeadlyConfig.BOSS_MOBS.object2IntEntrySet()) {
            BossItem i = new BossItem(pair.getIntValue(), (ResourceLocation)pair.getKey());
            BOSS_ITEMS.add(i);
        }
    }

    @Override
    public boolean isEnabled() {
        return !BOSS_ITEMS.isEmpty() && DeadlyConfig.bossChance > 0.0f;
    }
}

