/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.config;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.config.DeadlyConstants;
import shadows.apotheosis.util.RandomIntRange;
import shadows.placebo.config.Configuration;

public class DeadlyConfig {
    public static final List<ResourceLocation> DIM_WHITELIST = new ArrayList<ResourceLocation>();
    public static final List<ResourceLocation> BIOME_BLACKLIST = new ArrayList<ResourceLocation>();
    public static final List<EffectInstance> BRUTAL_POTIONS = new ArrayList<EffectInstance>();
    public static Object2IntMap<ResourceLocation> BRUTAL_MOBS = new Object2IntOpenHashMap();
    public static Object2IntMap<ResourceLocation> BOSS_MOBS = new Object2IntOpenHashMap();
    public static Object2IntMap<ResourceLocation> SWARM_MOBS = new Object2IntOpenHashMap();
    public static List<ResourceLocation> BLACKLISTED_POTIONS = new ArrayList<ResourceLocation>();
    public static Configuration config;
    public static RandomIntRange bossRegenLevel;
    public static RandomIntRange bossResistLevel;
    public static float bossFireRes;
    public static float bossWaterBreathing;
    public static RandomValueRange bossHealthMultiplier;
    public static RandomValueRange bossKnockbackResist;
    public static RandomValueRange bossSpeedMultiplier;
    public static RandomValueRange bossDamageMult;
    public static float bossEnchantChance;
    public static float bossPotionChance;
    public static int surfaceBossChance;
    public static int randomAffixItem;
    public static boolean surfaceBossLightning;
    public static int bossRarityOffset;
    public static float brutalSpawnerChance;
    public static float swarmSpawnerChance;
    public static float bossChance;
    public static Block bossFillerBlock;

    public static void loadConfigs() {
        String[] biomes;
        Configuration c = config;
        DeadlyConstants.BRUTAL_SPAWNER_STATS.load(c);
        DeadlyConstants.SWARM_SPAWNER_STATS.load(c);
        String[] dims = c.getStringList("Generation Dimension Whitelist", "general", new String[]{"overworld"}, "The dimensions that the deadly module will generate in.");
        DIM_WHITELIST.clear();
        for (String s : dims) {
            try {
                DIM_WHITELIST.add(new ResourceLocation(s.trim()));
            }
            catch (ResourceLocationException e) {
                DeadlyModule.LOGGER.error("Invalid dim whitelist entry: " + s + " will be ignored");
            }
        }
        for (String s : biomes = c.getStringList("Generation Biome Blacklist", "general", new String[]{"minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:cold_ocean", "minecraft:frozen_ocean", "minecraft:deep_warm_ocean", "minecraft:deep_frozen_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:deep_cold_ocean", "minecraft:ocean", "minecraft:deep_ocean"}, "The biomes that the deadly module will not generate in.")) {
            try {
                BIOME_BLACKLIST.add(new ResourceLocation(s.trim()));
            }
            catch (ResourceLocationException e) {
                DeadlyModule.LOGGER.error("Invalid biome blacklist entry: " + s + " will be ignored!");
            }
        }
        bossRegenLevel = DeadlyConfig.getRange(c, "Regen Level", "Bosses", bossRegenLevel, 0, Integer.MAX_VALUE, "The %s regeneration level of bosses.");
        bossResistLevel = DeadlyConfig.getRange(c, "Resistance Level", "Bosses", bossResistLevel, 0, Integer.MAX_VALUE, "The %s resistance level of bosses.");
        bossFireRes = c.getFloat("Fire Resistance", "Bosses", bossFireRes, 0.0f, Float.MAX_VALUE, "The percent chance a boss has fire resistance.");
        bossWaterBreathing = c.getFloat("Water Breathing", "Bosses", bossWaterBreathing, 0.0f, Float.MAX_VALUE, "The percent chance a boss has water breathing.");
        bossHealthMultiplier = DeadlyConfig.getRange(c, "Health Multiplier", "Bosses", bossHealthMultiplier, 0.0f, 2.1474836E9f, "The %s amount boss health is multiplied by.  Base hp * factor = final hp.");
        bossKnockbackResist = DeadlyConfig.getRange(c, "Knockback Resist", "Bosses", bossKnockbackResist, 0.0f, 2.1474836E9f, "The %s amount of knockback resist bosses have.");
        bossSpeedMultiplier = DeadlyConfig.getRange(c, "Speed Multiplier", "Bosses", bossSpeedMultiplier, 0.0f, 2.1474836E9f, "The %s amount boss speed is multiplied by.  Base speed * factor = final speed.");
        bossDamageMult = DeadlyConfig.getRange(c, "Damage Bonus", "Bosses", bossDamageMult, 0.0f, 2.1474836E9f, "The %s amount of extra damage bosses do, in half hearts.");
        bossEnchantChance = c.getFloat("Random Enchantment Chance", "Bosses", bossEnchantChance, 0.0f, 2.1474836E9f, "The chance a gear piece will be randomly enchanted.");
        bossPotionChance = c.getFloat("Random Potion Chance", "Bosses", bossPotionChance, 0.0f, 2.1474836E9f, "The chance a boss will have extra random potion effects.");
        String[] blacklistPotions = c.getStringList("Blacklisted Potions", "Bosses", new String[]{"forbidden_arcanus:spectral_vision"}, "A list of potions (registry names) that bosses cannot generate with.");
        BLACKLISTED_POTIONS.clear();
        for (String s : blacklistPotions) {
            BLACKLISTED_POTIONS.add(new ResourceLocation(s));
        }
        surfaceBossChance = c.getInt("Surface Boss Chance", "Bosses", surfaceBossChance, 1, 500000, "The 1/n chance that a naturally spawned mob that can see the sky is transformed into a boss.");
        randomAffixItem = c.getInt("Random Affix Chance", "Affixes", randomAffixItem, 1, 500000, "The 1/n chance that a naturally spawned mob will be granted an affix item.");
        surfaceBossLightning = c.getBoolean("Surface Boss Lightning", "Bosses", true, "If a lightning bolt strikes when a surface boss spawn occurs.");
        bossRarityOffset = c.getInt("Boss Rarity Offset", "Bosses", bossRarityOffset, 0, 999, "The rarity offset for boss item generation.  400 guarantees uncommon, 700 guarantees rare, 800 guarantees epic, 950 guarantees mythic.");
        brutalSpawnerChance = c.getFloat("Brutal Spawner Chance", "Frequencies", brutalSpawnerChance, 0.0f, 1.0f, "The chance (per chunk) for a brutal spawner to try spawning.");
        swarmSpawnerChance = c.getFloat("Swarm Spawner Chance", "Frequencies", swarmSpawnerChance, 0.0f, 1.0f, "The chance (per chunk) for a swarm spawner to try spawning.");
        bossChance = c.getFloat("Boss Chance", "Frequencies", bossChance, 0.0f, 1.0f, "The chance (per chunk) for a boss to try spawning.");
        ResourceLocation blockId = new ResourceLocation(c.getString("Boss Filler Block", "Bosses", bossFillerBlock.getRegistryName().toString(), "The block that spawns in a 5x5 underneath world-generated bosses."));
        if ((bossFillerBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockId)) == Blocks.field_150350_a) {
            DeadlyModule.LOGGER.error("Boss Filler Block {} was mapped to air, it will be reverted to red sandstone.", (Object)blockId);
            bossFillerBlock = Blocks.field_180395_cM;
        }
        String[] brutalFromCfg = c.getStringList("Brutal Spawner Mobs", "Brutal Spawners", DeadlyConstants.BRUTAL_DEFAULT_MOBS, "The possible spawn entries for brutal spawners.  Format is weight@entity, entity is a registry name.  apotheosis:random is a special name, used to generate a spawner that spawns any mob.");
        DeadlyConfig.loadEntitiesFromConfig(brutalFromCfg, BRUTAL_MOBS, "Brutal Spawner");
        String[] bossFromCfg = c.getStringList("Boss Spawner Mobs", "Bosses", DeadlyConstants.BOSS_DEFAULT_MOBS, "The possible mob types for bosses.  Format is weight@entity, entity is a registry name.");
        DeadlyConfig.loadEntitiesFromConfig(bossFromCfg, BOSS_MOBS, "Boss");
        String[] swarmFromCfg = c.getStringList("Swarm Spawner Mobs", "Swarm Spawners", DeadlyConstants.SWARM_DEFAULT_MOBS, "The possible spawn entries for swarm spawners.  Format is weight@entity, entity is a registry name.");
        DeadlyConfig.loadEntitiesFromConfig(swarmFromCfg, SWARM_MOBS, "Swarm Spawner");
        String[] brutalPotions = c.getStringList("Brutal Potion Effects", "Brutal Spawners", DeadlyConstants.BRUTAL_POTIONS, "The potion effects applied to all brutal mobs.  Format is potion@level, potion is a registry name.");
        BRUTAL_POTIONS.clear();
        for (String s : brutalPotions) {
            String[] split = s.split("@");
            try {
                int level = Math.max(1, Integer.parseInt(split[1]));
                ResourceLocation name = new ResourceLocation(split[0]);
                Effect p = (Effect)ForgeRegistries.POTIONS.getValue(name);
                if (p != null) {
                    BRUTAL_POTIONS.add(new EffectInstance(p, Integer.MAX_VALUE, level - 1));
                    continue;
                }
                DeadlyModule.LOGGER.error("Invalid brutal potion entry: " + s + ".  It will be ignored! (Potion does not exist)");
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                DeadlyModule.LOGGER.error("Invalid brutal potion entry: " + s + ".  It will be ignored! (Invalid format)");
            }
        }
        for (EntityType e : ForgeRegistries.ENTITIES) {
            if (e.func_220339_d() != EntityClassification.MONSTER) continue;
            c.getInt(e.getRegistryName().toString(), "Random Spawners", e.getRegistryName().func_110624_b().equals("minecraft") ? 8 : 1, 0, 50, "");
        }
    }

    public static int getWeightForEntry(EntityType<?> e) {
        return config.getInt(e.getRegistryName().toString(), "Random Spawners", e.getRegistryName().func_110624_b().equals("minecraft") ? 8 : 1, 0, 50, "");
    }

    public static RandomValueRange getRange(Configuration c, String name, String group, RandomValueRange range, float min, float max, String comment) {
        float rMin = c.getFloat("Min " + name, group, range.func_186509_a(), min, max, String.format(comment, "min"));
        float rMax = c.getFloat("Max " + name, group, range.func_186512_b(), min, max, String.format(comment, "max"));
        return RandomValueRange.func_215837_a((float)rMin, (float)rMax);
    }

    public static RandomIntRange getRange(Configuration c, String name, String group, RandomIntRange range, int min, int max, String comment) {
        int rMin = c.getInt("Min " + name, group, range.getMin(), min, max, String.format(comment, "min"));
        int rMax = c.getInt("Max " + name, group, range.getMax(), min, max, String.format(comment, "max"));
        return new RandomIntRange(rMin, rMax);
    }

    private static void loadEntitiesFromConfig(String[] entities, Object2IntMap<ResourceLocation> map, String type) {
        map.clear();
        for (String s : entities) {
            String[] split = s.split("@");
            try {
                int weight = Integer.parseInt(split[0]);
                ResourceLocation name = new ResourceLocation(split[1]);
                EntityType e = (EntityType)ForgeRegistries.ENTITIES.getValue(name);
                if (weight > 0 && (e != null || name.equals((Object)DeadlyConstants.RANDOM))) {
                    map.put((Object)name, weight);
                    continue;
                }
                DeadlyModule.LOGGER.error("Invalid {} entry: {}.  It will be ignored! (Weight <= 0 or Entity does not exist)", (Object)type, (Object)s);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                DeadlyModule.LOGGER.error("Invalid {} entry: {}.  It will be ignored!  (Invalid format)", (Object)type, (Object)s);
            }
        }
    }

    static {
        bossRegenLevel = new RandomIntRange(0, 2);
        bossResistLevel = new RandomIntRange(0, 3);
        bossFireRes = 1.0f;
        bossWaterBreathing = 1.0f;
        bossHealthMultiplier = new RandomValueRange(4.0f, 8.0f);
        bossKnockbackResist = new RandomValueRange(0.65f, 1.0f);
        bossSpeedMultiplier = new RandomValueRange(1.1f, 1.4f);
        bossDamageMult = new RandomValueRange(2.0f, 4.5f);
        bossEnchantChance = 0.45f;
        bossPotionChance = 0.65f;
        surfaceBossChance = 600;
        randomAffixItem = 250;
        surfaceBossLightning = true;
        bossRarityOffset = 475;
        brutalSpawnerChance = 0.18f;
        swarmSpawnerChance = 0.2f;
        bossChance = 0.07f;
        bossFillerBlock = Blocks.field_180395_cM;
    }
}

