/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix.impl.ranged;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.deadly.affix.AffixHelper;
import shadows.apotheosis.deadly.affix.impl.RangedAffix;
import shadows.apotheosis.deadly.affix.modifiers.AffixModifier;
import shadows.apotheosis.deadly.loot.EquipmentType;

public class SpectralShotAffix
extends RangedAffix {
    public SpectralShotAffix(int weight) {
        super(0.1f, 1.0f, weight);
    }

    @Override
    public boolean canApply(EquipmentType type) {
        return type == EquipmentType.RANGED;
    }

    @Override
    public void onArrowFired(LivingEntity user, AbstractArrowEntity arrow, ItemStack bow, float level) {
        if (user.field_70170_p.field_73012_v.nextFloat() <= level && !user.field_70170_p.field_72995_K) {
            ArrowItem arrowitem = (ArrowItem)Items.field_185166_h;
            AbstractArrowEntity spectralArrow = arrowitem.func_200887_a(user.field_70170_p, ItemStack.field_190927_a, user);
            spectralArrow.func_70186_c((double)user.field_70125_A, (double)user.field_70177_z, 0.0, 3.0f, 1.0f);
            this.cloneMotion(arrow, spectralArrow);
            spectralArrow.func_70243_d(arrow.func_70241_g());
            spectralArrow.func_70239_b(arrow.func_70242_d());
            spectralArrow.func_70240_a(arrow.field_70256_ap);
            spectralArrow.func_241209_g_(arrow.func_223314_ad());
            spectralArrow.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            spectralArrow.getPersistentData().func_74757_a("apoth.generated", true);
            arrow.field_70170_p.func_217376_c((Entity)spectralArrow);
        }
    }

    @Override
    public float apply(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        float lvl = this.range.func_186507_b(rand);
        if (modifier != null) {
            lvl = modifier.editLevel(this, lvl);
        }
        AffixHelper.addLore(stack, (ITextComponent)new TranslationTextComponent("affix." + this.getRegistryName() + ".desc", new Object[]{String.format("%.2f", Float.valueOf(lvl * 100.0f))}));
        return lvl;
    }

    private void cloneMotion(AbstractArrowEntity src, AbstractArrowEntity dest) {
        dest.func_213317_d(src.func_213322_ci().func_186678_a(1.0));
        dest.field_70177_z = src.field_70177_z;
        dest.field_70125_A = src.field_70125_A;
        dest.field_70126_B = dest.field_70177_z;
        dest.field_70127_C = dest.field_70125_A;
    }
}

