/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix.impl.melee;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.affix.attributes.CustomAttributes;
import shadows.apotheosis.deadly.affix.impl.AttributeAffix;
import shadows.apotheosis.deadly.loot.EquipmentType;

public class ColdDamageAffix
extends AttributeAffix {
    public static final DamageSource COLD = new DamageSource("apoth.frozen_solid").func_82726_p().func_151518_m();

    public ColdDamageAffix(int weight) {
        super(CustomAttributes.COLD_DAMAGE, 3.0f, 7.0f, AttributeModifier.Operation.ADDITION, weight);
    }

    @Override
    public boolean canApply(EquipmentType type) {
        return type == EquipmentType.SWORD;
    }

    @Override
    public void onEntityDamaged(LivingEntity user, Entity target, float level) {
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_76421_d, 20 * Math.max(3, (int)(level / 1.5f)), 1));
        }
        target.func_70097_a(COLD, Apotheosis.localAtkStrength * level);
    }

    @Override
    public float getMin() {
        return 1.0f;
    }

    @Override
    public float getMax() {
        return 10.0f;
    }
}

