/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module.underground;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.world.client.render.WrappedRenderer;
import vazkii.quark.content.world.config.UndergroundBiomeConfig;
import vazkii.quark.content.world.entity.WrappedEntity;
import vazkii.quark.content.world.gen.underground.SpiderNestUndergroundBiome;
import vazkii.quark.content.world.gen.underground.UndergroundBiome;
import vazkii.quark.content.world.module.underground.UndergroundBiomeModule;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class SpiderNestUndergroundBiomeModule
extends UndergroundBiomeModule {
    public static QuarkBlock cobbedstone;
    public static EntityType<WrappedEntity> wrappedType;
    @Config
    public static boolean enabledWrapped;

    @Override
    public void construct() {
        cobbedstone = new QuarkBlock("cobbedstone", this, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d));
        VariantHandler.addSlabStairsWall(cobbedstone);
        wrappedType = EntityType.Builder.func_220322_a(WrappedEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).setTrackingRange(80).setUpdateInterval(3).setCustomClientFactory((spawnEntity, world) -> new WrappedEntity((EntityType<? extends WrappedEntity>)wrappedType, (World)world)).func_206830_a("wrapped");
        RegistryHelper.register(wrappedType, (String)"wrapped");
        EntitySpawnHandler.addEgg(wrappedType, 2385253, 10459019, this, () -> enabledWrapped);
        super.construct();
    }

    @Override
    public void setup() {
        super.setup();
        GlobalEntityTypeAttributes.put(wrappedType, (AttributeModifierMap)ZombieEntity.func_234342_eQ_().func_233813_a_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(wrappedType, WrappedRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onZombieSpawn(LivingSpawnEvent.CheckSpawn event) {
        LivingEntity entity = event.getEntityLiving();
        Event.Result result = event.getResult();
        if (entity.func_200600_R() == EntityType.field_200725_aD && entity instanceof MobEntity && enabledWrapped && result != Event.Result.DENY) {
            MobEntity mob = (MobEntity)entity;
            if ((result == Event.Result.ALLOW || mob.func_213380_a((IWorld)entity.field_70170_p, event.getSpawnReason()) && mob.func_205019_a((IWorldReader)entity.field_70170_p)) && SpiderNestUndergroundBiomeModule.changeToWrapped((Entity)entity)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onZombieSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_200600_R() == EntityType.field_200725_aD && enabledWrapped && SpiderNestUndergroundBiomeModule.changeToWrapped((Entity)entity)) {
            event.setCanceled(true);
        }
    }

    private static boolean changeToWrapped(Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        for (int i = 0; i < 4; ++i) {
            pos = pos.func_177977_b();
            if (entity.field_70170_p.func_175623_d(pos)) continue;
            if (entity.field_70170_p.func_180495_p(pos).func_177230_c() == cobbedstone) {
                WrappedEntity wrapped = new WrappedEntity(wrappedType, entity.field_70170_p);
                Vector3d epos = entity.func_213303_ch();
                wrapped.func_70080_a(epos.field_72450_a, epos.field_72448_b, epos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
                entity.field_70170_p.func_217376_c((Entity)wrapped);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected UndergroundBiomeConfig getBiomeConfig() {
        return new UndergroundBiomeConfig((UndergroundBiome)new SpiderNestUndergroundBiome(), 80, Biome.Category.PLAINS);
    }

    @Override
    protected String getBiomeName() {
        return "spider_nest";
    }

    static {
        enabledWrapped = true;
    }
}

