/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.base.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.content.world.block.BlossomLeavesBlock;
import vazkii.quark.content.world.block.BlossomSaplingBlock;
import vazkii.quark.content.world.config.BlossomTreeConfig;
import vazkii.quark.content.world.gen.BlossomTreeGenerator;

@LoadModule(category=ModuleCategory.WORLD)
public class BlossomTreesModule
extends QuarkModule {
    @Config
    BlossomTreeConfig blue = new BlossomTreeConfig(200, Biome.Category.ICY);
    @Config
    BlossomTreeConfig lavender = new BlossomTreeConfig(100, Biome.Category.SWAMP);
    @Config
    BlossomTreeConfig orange = new BlossomTreeConfig(100, Biome.Category.SAVANNA);
    @Config
    BlossomTreeConfig pink = new BlossomTreeConfig(100, Biome.Category.EXTREME_HILLS);
    @Config
    BlossomTreeConfig yellow = new BlossomTreeConfig(200, Biome.Category.PLAINS);
    @Config
    BlossomTreeConfig red = new BlossomTreeConfig(30, Biome.Category.MESA);
    public static Map<BlossomSaplingBlock.BlossomTree, BlossomTreeConfig> trees = new HashMap<BlossomSaplingBlock.BlossomTree, BlossomTreeConfig>();

    @Override
    public void construct() {
        this.add("blue", MaterialColor.field_151674_s, this.blue);
        this.add("lavender", MaterialColor.field_151671_v, this.lavender);
        this.add("orange", MaterialColor.field_193562_N, this.orange);
        this.add("pink", MaterialColor.field_151671_v, this.pink);
        this.add("yellow", MaterialColor.field_151673_t, this.yellow);
        this.add("red", MaterialColor.field_151645_D, this.red);
    }

    @Override
    public void setup() {
        for (BlossomSaplingBlock.BlossomTree tree : trees.keySet()) {
            WorldGenHandler.addGenerator(this, new BlossomTreeGenerator(trees.get((Object)tree), tree), GenerationStage.Decoration.TOP_LAYER_MODIFICATION, 1);
        }
        this.enqueue(() -> {
            for (BlossomSaplingBlock.BlossomTree tree : trees.keySet()) {
                if (tree.leaf.func_177230_c().func_199767_j() != null) {
                    ComposterBlock.field_220299_b.put((Object)tree.leaf.func_177230_c().func_199767_j(), 0.3f);
                }
                if (tree.sapling.func_199767_j() == null) continue;
                ComposterBlock.field_220299_b.put((Object)tree.sapling.func_199767_j(), 0.3f);
            }
        });
    }

    private void add(String colorName, MaterialColor color, BlossomTreeConfig config) {
        BlossomLeavesBlock leaves = new BlossomLeavesBlock(colorName, this, color);
        BlossomSaplingBlock.BlossomTree tree = new BlossomSaplingBlock.BlossomTree((Block)leaves);
        BlossomSaplingBlock sapling = new BlossomSaplingBlock(colorName, this, tree, (Block)leaves);
        VariantHandler.addFlowerPot((Block)sapling, sapling.getRegistryName().func_110623_a(), (Function<AbstractBlock.Properties, AbstractBlock.Properties>)Functions.identity());
        trees.put(tree, config);
    }
}

