/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.multichunk.MultiChunkFeatureGenerator;
import vazkii.quark.content.world.module.SpiralSpiresModule;

public class SpiralSpireGenerator
extends MultiChunkFeatureGenerator {
    public SpiralSpireGenerator(DimensionConfig dimConfig) {
        super(dimConfig, NO_COND, 1892L);
    }

    @Override
    public int getFeatureRadius() {
        return SpiralSpiresModule.radius;
    }

    @Override
    public void generateChunkPart(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        double dist = chunkCorner.func_177951_i((Vector3i)src) / (double)(16 * SpiralSpiresModule.radius * (16 * SpiralSpiresModule.radius));
        if (dist > 0.5 && random.nextDouble() < 1.5 - dist) {
            return;
        }
        BlockPos pos = chunkCorner.func_177982_a(random.nextInt(16), 256, random.nextInt(16));
        Biome biome = this.getBiome((IWorld)world, pos);
        if (!SpiralSpiresModule.biomes.canSpawn(biome)) {
            return;
        }
        while (world.func_180495_p(pos).func_177230_c() != Blocks.field_150377_bs) {
            if ((pos = pos.func_177977_b()).func_177956_o() >= 10) continue;
            return;
        }
        this.makeSpike(world, generator, random, pos);
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkCorner) {
        if (!chunkCorner.func_218141_a(Vector3i.field_177959_e, 1050.0) && SpiralSpiresModule.rarity > 0 && random.nextInt(SpiralSpiresModule.rarity) == 0) {
            return new BlockPos[]{chunkCorner};
        }
        return new BlockPos[0];
    }

    public void makeSpike(WorldGenRegion world, ChunkGenerator chunk, Random rand, BlockPos pos) {
        int start;
        int y;
        int height = 50 + rand.nextInt(20);
        double heightComposition = 5.0 + rand.nextDouble() * 1.0;
        Supplier<BlockState> prov = () -> ((double)rand.nextFloat() < 0.05 ? Blocks.field_235399_ni_ : Blocks.field_150343_Z).func_176223_P();
        for (y = start = -5; y < height; ++y) {
            BlockPos test = pos.func_177981_b(y);
            BlockState state = world.func_180495_p(test);
            if (state.func_196958_f() || state.func_177230_c() == Blocks.field_150377_bs || state.func_177230_c() == Blocks.field_235399_ni_ || state.func_177230_c() == Blocks.field_150343_Z || state.func_177230_c() == SpiralSpiresModule.myalite_crystal) continue;
            return;
        }
        for (y = start; y < height; ++y) {
            if (y < 0 && !world.func_180495_p(pos.func_177981_b(y)).func_200132_m()) continue;
            double r = Math.abs((1.5707963267948966 - Math.atan(((double)Math.max(0, y) + 0.5) / ((double)height / heightComposition))) * 4.0);
            int ri = (int)Math.ceil(r);
            for (int i = -ri; i < ri; ++i) {
                for (int j = -ri; j < ri; ++j) {
                    if (i * i + j * j >= ri * ri) continue;
                    world.func_180501_a(pos.func_177982_a(i, y, j), prov.get(), 2);
                }
            }
        }
        int steps = 80 + rand.nextInt(30);
        int substeps = 10;
        int fullSteps = steps * substeps;
        int deteroirate = (int)((0.5 + rand.nextDouble() * 0.3) * (double)fullSteps);
        double spin = 0.12 + rand.nextDouble() * 0.16;
        double spread = 0.12 + rand.nextDouble() * 0.04;
        double upwardMotion = rand.nextDouble() * 0.2;
        if (rand.nextBoolean()) {
            spin *= -1.0;
        }
        BlockState state = SpiralSpiresModule.myalite_crystal.func_176223_P();
        for (int i = 0; i < fullSteps; ++i) {
            double t = (double)i * spin;
            int x = (int)(Math.sin(t / (double)substeps) * (double)i * spread / (double)substeps);
            int z = (int)(Math.cos(t / (double)substeps) * (double)i * spread / (double)substeps);
            int yp = y + (int)Math.round((double)i / (double)substeps * upwardMotion);
            BlockPos next = pos.func_177982_a(x, yp, z);
            float chance = 1.0f;
            if (i > deteroirate) {
                int deterStep = i - deteroirate;
                int maxSteps = fullSteps - deteroirate;
                chance -= (float)deterStep / (float)maxSteps;
            }
            if (!(rand.nextFloat() < chance)) continue;
            world.func_180501_a(next, state, 2);
        }
    }
}

