/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.network.MessageSerializer;
import vazkii.quark.api.IRotationLockable;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SetLockProfileMessage;
import vazkii.quark.content.building.block.VerticalSlabBlock;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class LockRotationModule
extends QuarkModule {
    private static final String TAG_LOCKED_ONCE = "quark:locked_once";
    private static final HashMap<UUID, LockProfile> lockProfiles = new HashMap();
    @OnlyIn(value=Dist.CLIENT)
    private LockProfile clientProfile;
    @OnlyIn(value=Dist.CLIENT)
    private KeyBinding keybind;

    @Override
    public void configChanged() {
        lockProfiles.clear();
    }

    @Override
    public void setup() {
        MessageSerializer.mapHandler(LockProfile.class, LockProfile::readProfile, LockProfile::writeProfile);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        this.keybind = ModKeybindHandler.init("lock_rotation", "k", "quark.gui.keygroup.misc");
    }

    public static BlockState fixBlockRotation(BlockState state, BlockItemUseContext ctx) {
        if (state == null || ctx.func_195999_j() == null || !ModuleLoader.INSTANCE.isModuleEnabled(LockRotationModule.class)) {
            return state;
        }
        UUID uuid = ctx.func_195999_j().func_110124_au();
        if (lockProfiles.containsKey(uuid)) {
            LockProfile profile = lockProfiles.get(uuid);
            BlockState transformed = LockRotationModule.getRotatedState(ctx.func_195991_k(), ctx.func_195995_a(), state, profile.facing.func_176734_d(), profile.half);
            if (!transformed.equals(state)) {
                return Block.func_199770_b((BlockState)transformed, (IWorld)ctx.func_195991_k(), (BlockPos)ctx.func_195995_a());
            }
        }
        return state;
    }

    public static BlockState getRotatedState(World world, BlockPos pos, BlockState state, Direction face, int half) {
        BlockState setState = state;
        ImmutableMap props = state.func_206871_b();
        Block block = state.func_177230_c();
        if (block instanceof IRotationLockable) {
            setState = ((IRotationLockable)block).applyRotationLock(world, pos, state, face, half);
        } else if (props.containsKey((Object)BlockStateProperties.field_208155_H)) {
            setState = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)face);
        } else if (props.containsKey(VerticalSlabBlock.TYPE) && props.get(VerticalSlabBlock.TYPE) != VerticalSlabBlock.VerticalSlabType.DOUBLE && face.func_176740_k() != Direction.Axis.Y) {
            setState = (BlockState)state.func_206870_a(VerticalSlabBlock.TYPE, (Comparable)((Object)Objects.requireNonNull(VerticalSlabBlock.VerticalSlabType.fromDirection(face))));
        } else if (props.containsKey((Object)BlockStateProperties.field_208157_J) && face.func_176740_k() != Direction.Axis.Y) {
            setState = block instanceof StairsBlock ? (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)face.func_176734_d()) : (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)face);
        } else if (props.containsKey((Object)BlockStateProperties.field_208148_A)) {
            setState = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)face.func_176740_k());
        } else if (props.containsKey((Object)BlockStateProperties.field_208156_I)) {
            setState = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208156_I, (Comparable)(face == Direction.DOWN ? face : face.func_176734_d()));
        }
        if (half != -1) {
            if (props.containsKey((Object)BlockStateProperties.field_208145_at) && props.get((Object)BlockStateProperties.field_208145_at) != SlabType.DOUBLE) {
                setState = (BlockState)setState.func_206870_a((Property)BlockStateProperties.field_208145_at, (Comparable)(half == 1 ? SlabType.TOP : SlabType.BOTTOM));
            } else if (props.containsKey((Object)BlockStateProperties.field_208164_Q)) {
                setState = (BlockState)setState.func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)(half == 1 ? Half.TOP : Half.BOTTOM));
            }
        }
        return setState;
    }

    @SubscribeEvent
    public void onPlayerLogoff(PlayerEvent.PlayerLoggedOutEvent event) {
        lockProfiles.remove(event.getPlayer().func_110124_au());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        this.acceptInput();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.acceptInput();
    }

    private void acceptInput() {
        Minecraft mc = Minecraft.func_71410_x();
        boolean down = this.keybind.func_151470_d();
        if (mc.func_195544_aj() && down) {
            LockProfile newProfile;
            RayTraceResult result = mc.field_71476_x;
            if (result instanceof BlockRayTraceResult && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult bresult = (BlockRayTraceResult)result;
                Vector3d hitVec = bresult.func_216347_e();
                Direction face = bresult.func_216354_b();
                int half = (int)((hitVec.field_72448_b - (double)((int)hitVec.field_72448_b)) * 2.0);
                if (face.func_176740_k() == Direction.Axis.Y) {
                    half = -1;
                }
                newProfile = new LockProfile(face.func_176734_d(), half);
            } else {
                Vector3d look = mc.field_71439_g.func_70040_Z();
                newProfile = new LockProfile(Direction.func_176737_a((float)((float)look.field_72450_a), (float)((float)look.field_72448_b), (float)((float)look.field_72449_c)), -1);
            }
            this.clientProfile = this.clientProfile != null && this.clientProfile.equals(newProfile) ? null : newProfile;
            QuarkNetwork.sendToServer(new SetLockProfileMessage(this.clientProfile));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onHUDRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && this.clientProfile != null) {
            Minecraft mc = Minecraft.func_71410_x();
            MatrixStack matrix = event.getMatrixStack();
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            mc.field_71446_o.func_110577_a(MiscUtil.GENERAL_ICONS);
            MainWindow window = event.getWindow();
            int x = window.func_198107_o() / 2 + 20;
            int y = window.func_198087_p() / 2 - 8;
            Screen.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)(this.clientProfile.facing.ordinal() * 16), (float)65.0f, (int)16, (int)16, (int)256, (int)256);
            if (this.clientProfile.half > -1) {
                Screen.func_238463_a_((MatrixStack)matrix, (int)(x + 16), (int)y, (float)(this.clientProfile.half * 16), (float)81.0f, (int)16, (int)16, (int)256, (int)256);
            }
        }
    }

    public static void setProfile(PlayerEntity player, LockProfile profile) {
        UUID uuid = player.func_110124_au();
        if (profile == null) {
            lockProfiles.remove(uuid);
        } else {
            boolean locked = player.getPersistentData().func_74767_n(TAG_LOCKED_ONCE);
            if (!locked) {
                IFormattableTextComponent keybind = new KeybindTextComponent("quark.keybind.lock_rotation").func_240699_a_(TextFormatting.AQUA);
                TranslationTextComponent text = new TranslationTextComponent("quark.misc.rotation_lock", new Object[]{keybind});
                player.func_145747_a((ITextComponent)text, UUID.randomUUID());
                player.getPersistentData().func_74757_a(TAG_LOCKED_ONCE, true);
            }
            lockProfiles.put(uuid, profile);
        }
    }

    public static class LockProfile {
        public final Direction facing;
        public final int half;

        public LockProfile(Direction facing, int half) {
            this.facing = facing;
            this.half = half;
        }

        public static LockProfile readProfile(PacketBuffer buf, Field field) {
            boolean valid = buf.readBoolean();
            if (!valid) {
                return null;
            }
            int face = buf.readInt();
            int half = buf.readInt();
            return new LockProfile(Direction.func_82600_a((int)face), half);
        }

        public static void writeProfile(PacketBuffer buf, Field field, LockProfile p) {
            if (p == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeInt(p.facing.func_176745_a());
                buf.writeInt(p.half);
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof LockProfile)) {
                return false;
            }
            LockProfile otherProfile = (LockProfile)other;
            return otherProfile.facing == this.facing && otherProfile.half == this.half;
        }

        public int hashCode() {
            return this.facing.hashCode() * 31 + this.half;
        }
    }
}

