/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.ai.RunAwayFromPikesGoal;
import vazkii.quark.content.tools.client.render.SkullPikeRenderer;
import vazkii.quark.content.tools.entity.SkullPikeEntity;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class SkullPikesModule
extends QuarkModule {
    public static EntityType<SkullPikeEntity> skullPikeType;
    public static ITag<Block> pikeTrophiesTag;
    @Config
    public static double pikeRange;

    @Override
    public void construct() {
        skullPikeType = EntityType.Builder.func_220322_a(SkullPikeEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new SkullPikeEntity(skullPikeType, (World)world)).func_206830_a("skull_pike");
        RegistryHelper.register(skullPikeType, (String)"skull_pike");
    }

    @Override
    public void setup() {
        pikeTrophiesTag = BlockTags.createOptional((ResourceLocation)new ResourceLocation("quark", "pike_trophies"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(skullPikeType, SkullPikeRenderer::new);
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        BlockPos pos;
        BlockPos down;
        World world;
        BlockState downState;
        IWorld iworld;
        BlockState state = event.getPlacedBlock();
        if (state.func_177230_c().func_203417_a(pikeTrophiesTag) && (iworld = event.getWorld()) instanceof World && (downState = (world = (World)iworld).func_180495_p(down = (pos = event.getPos()).func_177977_b())).func_177230_c().func_203417_a((ITag)BlockTags.field_219748_G)) {
            SkullPikeEntity pike = new SkullPikeEntity(skullPikeType, world);
            pike.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            world.func_217376_c((Entity)pike);
        }
    }

    @SubscribeEvent
    public void onMonsterAppear(EntityJoinWorldEvent event) {
        Entity e = event.getEntity();
        if (e instanceof MonsterEntity && !(e instanceof PatrollerEntity) && e.func_184222_aU()) {
            MonsterEntity monster = (MonsterEntity)e;
            boolean alreadySetUp = monster.field_70714_bg.field_220892_d.stream().anyMatch(goal -> goal.func_220772_j() instanceof RunAwayFromPikesGoal);
            if (!alreadySetUp) {
                monster.field_70714_bg.func_75776_a(3, (Goal)new RunAwayFromPikesGoal((CreatureEntity)monster, (float)pikeRange, 1.0, 1.2));
            }
        }
    }

    static {
        pikeRange = 5.0;
    }
}

