/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.ITrowelable;
import vazkii.quark.api.IUsageTickerOverride;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.tools.module.SeedPouchModule;

public class SeedPouchItem
extends QuarkItem
implements IUsageTickerOverride,
ITrowelable {
    public static final String TAG_STORED_ITEM = "storedItem";
    public static final String TAG_COUNT = "itemCount";

    public SeedPouchItem(QuarkModule module) {
        super("seed_pouch", module, new Item.Properties().func_200917_a(1).func_200918_c(SeedPouchModule.maxItems + 1).func_200916_a(ItemGroup.field_78040_i));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float itemFraction(ItemStack stack, ClientWorld world, LivingEntity entityIn) {
        Pair<ItemStack, Integer> contents;
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            ItemStack held = player.field_71071_by.func_70445_o();
            if (SeedPouchItem.canTakeItem(stack, held)) {
                return 0.0f;
            }
        }
        if ((contents = SeedPouchItem.getContents(stack)) == null) {
            return 0.0f;
        }
        return (float)((Integer)contents.getRight()).intValue() / (float)SeedPouchModule.maxItems;
    }

    public static Pair<ItemStack, Integer> getContents(ItemStack stack) {
        CompoundNBT nbt = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_STORED_ITEM, (boolean)true);
        if (nbt == null) {
            return null;
        }
        ItemStack contained = ItemStack.func_199557_a((CompoundNBT)nbt);
        int count = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_COUNT, (int)0);
        return Pair.of((Object)contained, (Object)count);
    }

    public static boolean canTakeItem(ItemStack stack, ItemStack incoming) {
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents == null) {
            return incoming.func_77973_b().func_206844_a((ITag)Tags.Items.SEEDS);
        }
        return (Integer)contents.getRight() < SeedPouchModule.maxItems && ItemStack.func_179545_c((ItemStack)incoming, (ItemStack)((ItemStack)contents.getLeft()));
    }

    public static void setItemStack(ItemStack stack, ItemStack target) {
        ItemStack copy = target.func_77946_l();
        copy.func_190920_e(1);
        CompoundNBT nbt = new CompoundNBT();
        copy.func_77955_b(nbt);
        ItemNBTHelper.setCompound((ItemStack)stack, (String)TAG_STORED_ITEM, (CompoundNBT)nbt);
        SeedPouchItem.setCount(stack, target.func_190916_E());
    }

    public static void setCount(ItemStack stack, int count) {
        if (count <= 0) {
            stack.func_77978_p().func_82580_o(TAG_STORED_ITEM);
            stack.func_196085_b(0);
            return;
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_COUNT, (int)count);
        stack.func_196085_b(SeedPouchModule.maxItems + 1 - count);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 65280;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent base = super.func_200295_i(stack);
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents == null) {
            return base;
        }
        IFormattableTextComponent comp = base.func_230532_e_();
        comp.func_230529_a_((ITextComponent)new StringTextComponent(" ("));
        comp.func_230529_a_(((ItemStack)contents.getLeft()).func_200301_q());
        comp.func_230529_a_((ITextComponent)new StringTextComponent(")"));
        return comp;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents != null) {
            ItemStack target = ((ItemStack)contents.getLeft()).func_77946_l();
            int total = (Integer)contents.getRight();
            target.func_190920_e(Math.min(target.func_77976_d(), total));
            PlayerEntity player = context.func_195999_j();
            if (!player.func_225608_bj_()) {
                return this.placeSeed(context, target, context.func_195995_a(), total);
            }
            ActionResultType bestRes = ActionResultType.FAIL;
            int range = SeedPouchModule.shiftRange;
            int blocks = range * range;
            int shift = -((int)Math.floor(range / 2));
            for (int i = 0; i < blocks; ++i) {
                int x = shift + i % range;
                int z = shift + i / range;
                ActionResultType res = this.placeSeed(context, target, context.func_195995_a().func_177982_a(x, 0, z), total);
                contents = SeedPouchItem.getContents(stack);
                if (contents == null) break;
                total = (Integer)contents.getRight();
                if (bestRes.func_226246_a_()) continue;
                bestRes = res;
            }
            return bestRes;
        }
        return super.func_195939_a(context);
    }

    private ActionResultType placeSeed(ItemUseContext context, ItemStack target, BlockPos pos, int total) {
        int diff;
        ActionResultType res = target.func_77973_b().func_195939_a((ItemUseContext)new PouchItemUseContext(context, target, pos));
        int n = diff = res == ActionResultType.CONSUME ? 1 : 0;
        if (diff > 0 && !context.func_195999_j().func_184812_l_()) {
            SeedPouchItem.setCount(context.func_195996_i(), total - diff);
        }
        return res;
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (SeedPouchModule.showAllVariantsInCreative && this.isEnabled() && this.func_194125_a(group)) {
            List tagItems = null;
            try {
                tagItems = SeedPouchModule.seedPouchHoldableTag.func_230236_b_();
            }
            catch (IllegalStateException e) {
                return;
            }
            for (Item i : tagItems) {
                if (!ModuleLoader.INSTANCE.isItemEnabled(i)) continue;
                ItemStack stack = new ItemStack((IItemProvider)this);
                SeedPouchItem.setItemStack(stack, new ItemStack((IItemProvider)i));
                SeedPouchItem.setCount(stack, SeedPouchModule.maxItems);
                items.add((Object)stack);
            }
        }
    }

    @Override
    public ItemStack getUsageTickerItem(ItemStack stack) {
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents != null) {
            return (ItemStack)contents.getLeft();
        }
        return stack;
    }

    @Override
    public int getUsageTickerCountForItem(ItemStack stack, Predicate<ItemStack> target) {
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents != null && target.test((ItemStack)contents.getLeft())) {
            return (Integer)contents.getRight();
        }
        return 0;
    }

    class PouchItemUseContext
    extends ItemUseContext {
        protected PouchItemUseContext(ItemUseContext parent, ItemStack stack, BlockPos targetPos) {
            super(parent.func_195991_k(), parent.func_195999_j(), parent.func_221531_n(), stack, new BlockRayTraceResult(parent.func_221532_j(), parent.func_196000_l(), targetPos, parent.func_221533_k()));
        }
    }
}

