/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.config.BiomeTypeConfig;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.config.EntitySpawnConfig;
import vazkii.quark.content.mobs.client.render.ToretoiseRenderer;
import vazkii.quark.content.mobs.entity.ToretoiseEntity;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class ToretoiseModule
extends QuarkModule {
    public static EntityType<ToretoiseEntity> toretoiseType;
    @Config
    public static int maxYLevel;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static EntitySpawnConfig spawnConfig;

    @Override
    public void construct() {
        toretoiseType = EntityType.Builder.func_220322_a(ToretoiseEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(2.0f, 1.0f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new ToretoiseEntity((EntityType<? extends ToretoiseEntity>)toretoiseType, (World)world)).func_206830_a("toretoise");
        RegistryHelper.register(toretoiseType, (String)"toretoise");
        EntitySpawnHandler.registerSpawn(this, toretoiseType, EntityClassification.MONSTER, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ToretoiseEntity::spawnPredicate, spawnConfig);
        EntitySpawnHandler.addEgg(toretoiseType, 5587259, 3682871, spawnConfig);
    }

    @Override
    public void setup() {
        GlobalEntityTypeAttributes.put(toretoiseType, (AttributeModifierMap)ToretoiseEntity.prepareAttributes().func_233813_a_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(toretoiseType, ToretoiseRenderer::new);
    }

    static {
        maxYLevel = 32;
        dimensions = DimensionConfig.overworld(false);
        spawnConfig = new EntitySpawnConfig(100, 1, 1, new BiomeTypeConfig(true, Biome.Category.NONE, Biome.Category.NETHER, Biome.Category.THEEND));
    }
}

