/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectType;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.BrewingHandler;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.recipe.FlagIngredient;
import vazkii.quark.base.util.QuarkEffect;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.config.BiomeTypeConfig;
import vazkii.quark.base.world.config.EntitySpawnConfig;
import vazkii.quark.content.mobs.client.render.CrabRenderer;
import vazkii.quark.content.mobs.entity.CrabEntity;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class CrabsModule
extends QuarkModule {
    public static EntityType<CrabEntity> crabType;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config(flag="crab_brewing")
    public static boolean enableBrewing;

    @Override
    public void construct() {
        new QuarkItem("crab_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(1).func_221454_a(0.3f).func_221453_d()));
        new QuarkItem("cooked_crab_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(8).func_221454_a(0.8f).func_221453_d()));
        QuarkItem shell = new QuarkItem("crab_shell", this, new Item.Properties().func_200916_a(ItemGroup.field_78038_k)).setCondition(() -> enableBrewing);
        QuarkEffect resilience = new QuarkEffect("resilience", EffectType.BENEFICIAL, 5970436);
        resilience.func_220304_a(Attributes.field_233820_c_, "2ddf3f0a-f386-47b6-aeb0-6bd32851f215", 0.5, AttributeModifier.Operation.ADDITION);
        BrewingHandler.addPotionMix("crab_brewing", () -> CrabsModule.lambda$construct$1((Item)shell), resilience);
        crabType = EntityType.Builder.func_220322_a(CrabEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 0.5f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).setCustomClientFactory((spawnEntity, world) -> new CrabEntity((EntityType<? extends CrabEntity>)crabType, (World)world)).func_206830_a("crab");
        RegistryHelper.register(crabType, (String)"crab");
        EntitySpawnHandler.registerSpawn(this, crabType, EntityClassification.CREATURE, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CrabEntity::spawnPredicate, spawnConfig);
        EntitySpawnHandler.addEgg(crabType, 8993826, 9528648, spawnConfig);
    }

    @Override
    public void setup() {
        GlobalEntityTypeAttributes.put(crabType, (AttributeModifierMap)CrabEntity.prepareAttributes().func_233813_a_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(crabType, CrabRenderer::new);
    }

    private static /* synthetic */ Ingredient lambda$construct$1(Item shell) {
        return new FlagIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{shell}), "crabs");
    }

    static {
        spawnConfig = new EntitySpawnConfig(5, 1, 3, new BiomeTypeConfig(false, Biome.Category.BEACH));
        enableBrewing = true;
    }
}

