/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.automation.module.IronRodModule;
import vazkii.quark.content.mobs.module.ToretoiseModule;
import vazkii.quark.content.world.module.CaveRootsModule;

public class ToretoiseEntity
extends AnimalEntity {
    public static final int ORE_TYPES = 4;
    private static final int DEFAULT_EAT_COOLDOWN = 1200;
    public static final int ANGERY_TIME = 20;
    private static final String TAG_TAMED = "tamed";
    private static final String TAG_ORE = "oreType";
    private static final String TAG_EAT_COOLDOWN = "eatCooldown";
    private static final String TAG_ANGERY_TICKS = "angeryTicks";
    public int rideTime;
    private boolean isTamed;
    private int eatCooldown;
    public int angeryTicks;
    private Ingredient goodFood;
    private LivingEntity lastAggressor;
    private static final DataParameter<Integer> ORE_TYPE = EntityDataManager.func_187226_a(ToretoiseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ToretoiseEntity(EntityType<? extends ToretoiseEntity> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ORE_TYPE, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new TemptGoal((CreatureEntity)this, 1.25, this.getGoodFood(), false));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    private Ingredient getGoodFood() {
        if (this.goodFood == null) {
            this.goodFood = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModuleLoader.INSTANCE.isModuleEnabled(CaveRootsModule.class) ? CaveRootsModule.rootItem : Items.field_221774_cw});
        }
        return this.goodFood;
    }

    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, ILivingEntityData p_213386_4_, CompoundNBT p_213386_5_) {
        this.popOre(true);
        return p_213386_4_;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public boolean func_213743_em() {
        return this.getOreType() == 0 && this.eatCooldown == 0;
    }

    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return null;
    }

    public void func_70071_h_() {
        int ore;
        super.func_70071_h_();
        AxisAlignedBB aabb = this.func_174813_aQ();
        double rheight = this.getOreType() == 0 ? 1.0 : 1.4;
        aabb = new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72338_b + rheight, aabb.field_72334_f);
        this.func_174826_a(aabb);
        Entity riding = this.func_184187_bx();
        this.rideTime = riding != null ? ++this.rideTime : 0;
        if (this.eatCooldown > 0) {
            --this.eatCooldown;
        }
        if (this.angeryTicks > 0 && this.func_70089_S()) {
            --this.angeryTicks;
            if (this.field_70122_E) {
                int dangerRange = 3;
                double x = this.func_226277_ct_() + (double)(this.func_213311_cf() / 2.0f);
                double y = this.func_226278_cu_();
                double z = this.func_226281_cx_() + (double)(this.func_213311_cf() / 2.0f);
                if (this.field_70170_p instanceof ServerWorld) {
                    if (this.angeryTicks == 3) {
                        this.func_184185_a(SoundEvents.field_187926_gz, 1.0f, 0.2f);
                    } else if (this.angeryTicks == 0) {
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, x, y, z, 200, (double)dangerRange, 0.5, (double)dangerRange, 0.0);
                    }
                }
                if (this.angeryTicks == 0) {
                    AxisAlignedBB hurtAabb = new AxisAlignedBB(x - (double)dangerRange, y - 1.0, z - (double)dangerRange, x + (double)dangerRange, y + 1.0, z + (double)dangerRange);
                    List hurtMeDaddy = this.field_70170_p.func_175647_a(LivingEntity.class, hurtAabb, e -> !(e instanceof ToretoiseEntity));
                    ToretoiseEntity aggressor = this.lastAggressor == null ? this : this.lastAggressor;
                    DamageSource damageSource = DamageSource.func_76358_a((LivingEntity)aggressor);
                    for (LivingEntity e2 : hurtMeDaddy) {
                        e2.func_70097_a(damageSource, (float)(4 + this.field_70170_p.func_175659_aa().ordinal()));
                    }
                }
            }
        }
        if ((ore = this.getOreType()) != 0) {
            AxisAlignedBB ourBoundingBox = this.func_174813_aQ();
            BlockPos min = new BlockPos((double)Math.round(ourBoundingBox.field_72340_a), (double)Math.round(ourBoundingBox.field_72338_b), (double)Math.round(ourBoundingBox.field_72339_c));
            BlockPos max = new BlockPos((double)Math.round(ourBoundingBox.field_72336_d), (double)Math.round(ourBoundingBox.field_72337_e), (double)Math.round(ourBoundingBox.field_72334_f));
            block1: for (int ix = min.func_177958_n(); ix <= max.func_177958_n(); ++ix) {
                for (int iy = min.func_177956_o(); iy <= max.func_177956_o(); ++iy) {
                    for (int iz = min.func_177952_p(); iz <= max.func_177952_p(); ++iz) {
                        PistonTileEntity piston;
                        BlockState pistonState;
                        TileEntity tile;
                        BlockPos test = new BlockPos(ix, iy, iz);
                        BlockState state = this.field_70170_p.func_180495_p(test);
                        if (state.func_177230_c() != Blocks.field_196603_bb || !((tile = this.field_70170_p.func_175625_s(test)) instanceof PistonTileEntity) || (pistonState = (piston = (PistonTileEntity)tile).func_200230_i()).func_177230_c() != IronRodModule.iron_rod) continue;
                        this.dropOre(ore);
                        break block1;
                    }
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity e = source.func_76364_f();
        int ore = this.getOreType();
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack held = living.func_184614_ca();
            if (ore != 0 && held.func_77973_b().getToolTypes(held).contains(ToolType.PICKAXE)) {
                if (!this.field_70170_p.field_72995_K) {
                    if (held.func_77984_f() && e instanceof PlayerEntity) {
                        MiscUtil.damageStack((PlayerEntity)e, Hand.MAIN_HAND, held, 1);
                    }
                    this.dropOre(ore);
                }
                return false;
            }
            if (this.angeryTicks == 0) {
                this.angeryTicks = 20;
                this.lastAggressor = living;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void dropOre(int ore) {
        this.func_184185_a(SoundEvents.field_219637_fL, 1.0f, 0.6f);
        Item drop = null;
        int countMult = 1;
        switch (ore) {
            case 1: {
                drop = Items.field_151044_h;
                break;
            }
            case 2: {
                drop = Items.field_191525_da;
                countMult *= 9;
                break;
            }
            case 3: {
                drop = Items.field_151137_ax;
                countMult *= 3;
                break;
            }
            case 4: {
                drop = Items.field_196128_bn;
                countMult *= 2;
            }
        }
        if (drop != null) {
            int count = 1;
            while (this.field_70146_Z.nextBoolean()) {
                ++count;
            }
            this.func_70099_a(new ItemStack((IItemProvider)drop, count *= countMult), 1.2f);
        }
        this.field_70180_af.func_187227_b(ORE_TYPE, (Object)0);
    }

    public void func_146082_f(PlayerEntity player) {
        this.func_204700_e(0);
    }

    public void func_204700_e(int ticks) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_184185_a(SoundEvents.field_187537_bA, 0.5f + 0.5f * (float)this.field_70170_p.field_73012_v.nextInt(2), (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        this.func_70691_i(8.0f);
        if (!this.isTamed) {
            this.isTamed = true;
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 20, 0.5, 0.5, 0.5, 0.0);
            }
        } else {
            this.popOre(false);
        }
    }

    private void popOre(boolean natural) {
        if (this.getOreType() == 0 && (natural || this.field_70170_p.field_73012_v.nextInt(3) == 0)) {
            int ore = this.field_70146_Z.nextInt(4) + 1;
            this.field_70180_af.func_187227_b(ORE_TYPE, (Object)ore);
            if (!natural) {
                this.eatCooldown = 1200;
                if (this.field_70170_p instanceof ServerWorld) {
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 100, 0.6, 0.6, 0.6, 0.0);
                    this.func_184185_a(SoundEvents.field_187845_fY, 10.0f, 0.7f);
                }
            }
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.getGoodFood().test(stack);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isTamed;
    }

    public static boolean spawnPredicate(EntityType<? extends ToretoiseEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && pos.func_177956_o() <= ToretoiseModule.maxYLevel && MiscUtil.validSpawnLight(world, pos, rand) && MiscUtil.validSpawnLocation(type, (IWorld)world, reason, pos);
    }

    public boolean func_213380_a(@Nonnull IWorld world, SpawnReason reason) {
        BlockState state = world.func_180495_p(new BlockPos(this.func_213303_ch()).func_177977_b());
        if (state.func_185904_a() != Material.field_151576_e) {
            return false;
        }
        return ToretoiseModule.dimensions.canSpawnHere(world);
    }

    protected void func_70664_aZ() {
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.6f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203277_iv;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203261_iA;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203263_iC;
    }

    public int getOreType() {
        return (Integer)this.field_70180_af.func_187225_a(ORE_TYPE);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(TAG_TAMED, this.isTamed);
        compound.func_74768_a(TAG_ORE, this.getOreType());
        compound.func_74768_a(TAG_EAT_COOLDOWN, this.eatCooldown);
        compound.func_74768_a(TAG_ANGERY_TICKS, this.angeryTicks);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.isTamed = compound.func_74767_n(TAG_TAMED);
        this.field_70180_af.func_187227_b(ORE_TYPE, (Object)compound.func_74762_e(TAG_ORE));
        this.eatCooldown = compound.func_74762_e(TAG_EAT_COOLDOWN);
        this.angeryTicks = compound.func_74762_e(TAG_ANGERY_TICKS);
    }

    public static AttributeModifierMap.MutableAttribute prepareAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.08).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public ToretoiseEntity func_241840_a(ServerWorld sworld, AgeableEntity otherParent) {
        ToretoiseEntity e = new ToretoiseEntity(ToretoiseModule.toretoiseType, this.field_70170_p);
        e.func_70106_y();
        return e;
    }
}

