/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.content.mobs.ai.RaveGoal;
import vazkii.quark.content.mobs.module.CrabsModule;

public class CrabEntity
extends AnimalEntity
implements IEntityAdditionalSpawnData {
    public static final ResourceLocation CRAB_LOOT_TABLE = new ResourceLocation("quark", "entities/crab");
    private static final DataParameter<Float> SIZE_MODIFIER = EntityDataManager.func_187226_a(CrabEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(CrabEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static int lightningCooldown;
    private Ingredient temptationItems;
    private boolean crabRave;
    private BlockPos jukeboxPosition;

    public CrabEntity(EntityType<? extends CrabEntity> type, World worldIn) {
        this(type, worldIn, 1.0f);
    }

    public CrabEntity(EntityType<? extends CrabEntity> type, World worldIn, float sizeModifier) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.LAVA, -1.0f);
        if (sizeModifier != 1.0f) {
            this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
    }

    public static boolean spawnPredicate(EntityType<? extends AnimalEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151595_p && world.func_201696_r(pos) > 8;
    }

    public static void rave(IWorld world, BlockPos pos, boolean raving) {
        for (CrabEntity crab : world.func_217357_a(CrabEntity.class, new AxisAlignedBB(pos).func_186662_g(3.0))) {
            crab.party(pos, raving);
        }
    }

    public float func_205022_a(BlockPos pos, IWorldReader world) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150354_m ? 10.0f : world.func_205052_D(pos) - 0.5f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Nonnull
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE_MODIFIER, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(VARIANT, (Object)-1);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return QuarkSounds.ENTITY_CRAB_IDLE;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return QuarkSounds.ENTITY_CRAB_DIE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return QuarkSounds.ENTITY_CRAB_HURT;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 0.2f * size.field_220316_b;
    }

    public float getSizeModifier() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE_MODIFIER)).floatValue();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new RaveGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, this.getTemptationItems()));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute prepareAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233826_i_, 3.0).func_233815_a_(Attributes.field_233827_j_, 2.0).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    public void func_70071_h_() {
        BlockPos below;
        BlockState belowState;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (Integer)this.field_70180_af.func_187225_a(VARIANT) == -1) {
            int variant = 0;
            if (this.field_70146_Z.nextBoolean()) {
                variant += this.field_70146_Z.nextInt(2) + 1;
            }
            this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        }
        this.field_70138_W = this.field_70171_ac ? 1.0f : 0.6f;
        if (lightningCooldown > 0) {
            --lightningCooldown;
            this.func_70066_B();
        }
        Vector3d pos = this.func_213303_ch();
        if (this.isRaving() && (this.jukeboxPosition == null || this.jukeboxPosition.func_218140_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, true) > 24.0 || this.field_70170_p.func_180495_p(this.jukeboxPosition).func_177230_c() != Blocks.field_150421_aI)) {
            this.party(null, false);
        }
        if (this.isRaving() && this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0 && (belowState = this.field_70170_p.func_180495_p(below = this.func_233580_cy_().func_177977_b())).func_185904_a() == Material.field_151595_p) {
            this.field_70170_p.func_217379_c(2001, below, Block.func_196246_j((BlockState)belowState));
        }
    }

    @Nonnull
    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.getSizeModifier());
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_180137_b || this.getSizeModifier() > 1.0f && source.func_76347_k();
    }

    public void func_241841_a(ServerWorld sworld, LightningBoltEntity lightningBolt) {
        if (lightningCooldown > 0 || this.field_70170_p.field_72995_K) {
            return;
        }
        float sizeMod = this.getSizeModifier();
        if (sizeMod <= 15.0f) {
            this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("Lightning Bonus", 0.5, AttributeModifier.Operation.ADDITION));
            this.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier("Lightning Debuff", -0.05, AttributeModifier.Operation.ADDITION));
            this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("Lightning Bonus", 0.125, AttributeModifier.Operation.ADDITION));
            float sizeModifier = Math.min(sizeMod + 1.0f, 16.0f);
            this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
            this.func_213323_x_();
            lightningCooldown = 150;
        }
    }

    public void func_70108_f(@Nonnull Entity entityIn) {
        if (this.getSizeModifier() <= 1.0f) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && entityIn instanceof LivingEntity && !(entityIn instanceof CrabEntity)) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return !stack.func_190926_b() && this.getTemptationItems().test(stack);
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O, Items.field_151076_bf}), Ingredient.func_199805_a((ITag)ItemTags.field_206964_G)}));
        }
        return this.temptationItems;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld sworld, @Nonnull AgeableEntity other) {
        return new CrabEntity(CrabsModule.crabType, this.field_70170_p);
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return CRAB_LOOT_TABLE;
    }

    public int getVariant() {
        return Math.max(0, (Integer)this.field_70180_af.func_187225_a(VARIANT));
    }

    public void party(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.crabRave = isPartying;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
        this.party(pos, isPartying);
    }

    public boolean isRaving() {
        return this.crabRave;
    }

    public void func_184206_a(@Nonnull DataParameter<?> parameter) {
        if (parameter.equals(SIZE_MODIFIER)) {
            this.func_213323_x_();
        }
        super.func_184206_a(parameter);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.getSizeModifier());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(buffer.readFloat()));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        lightningCooldown = compound.func_74762_e("LightningCooldown");
        if (compound.func_74764_b("EnemyCrabRating")) {
            float sizeModifier = compound.func_74760_g("EnemyCrabRating");
            this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
        if (compound.func_74764_b("Variant")) {
            this.field_70180_af.func_187227_b(VARIANT, (Object)compound.func_74762_e("Variant"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("EnemyCrabRating", this.getSizeModifier());
        compound.func_74768_a("LightningCooldown", lightningCooldown);
        compound.func_74768_a("Variant", ((Integer)this.field_70180_af.func_187225_a(VARIANT)).intValue());
    }
}

