/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.recipe;

import com.google.gson.JsonObject;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MixedChestRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    final ResourceLocation res;
    NonNullList<Ingredient> ingredients;

    public MixedChestRecipe(ResourceLocation res) {
        this.res = res;
    }

    public boolean func_194133_a(int x, int y) {
        return x == 3 && y == 3;
    }

    public ItemStack getCraftingResult(CraftingInventory arg0) {
        return new ItemStack((IItemProvider)Blocks.field_150486_ae);
    }

    public ResourceLocation func_199560_c() {
        return this.res;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)Blocks.field_150486_ae);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean matches(CraftingInventory inv, World world) {
        if (inv.func_70301_a(4).func_190926_b()) {
            ItemStack first = null;
            boolean foundDifference = false;
            for (int i = 0; i < 9; ++i) {
                if (i == 4) continue;
                ItemStack stack = inv.func_70301_a(i);
                if (!stack.func_190926_b() && stack.func_77973_b().func_206844_a((ITag)ItemTags.field_199905_b)) {
                    if (first == null) {
                        first = stack;
                        continue;
                    }
                    if (ItemStack.func_179545_c((ItemStack)first, (ItemStack)stack) && this.isChestMaterial(stack.func_77973_b())) continue;
                    foundDifference = true;
                    continue;
                }
                return false;
            }
            return foundDifference;
        }
        return false;
    }

    private boolean isChestMaterial(Item item) {
        ResourceLocation res = item.getRegistryName();
        if (res.func_110624_b().equals("minecraft")) {
            return true;
        }
        ResourceLocation check = new ResourceLocation(res.func_110624_b(), res.func_110623_a().replace("_planks", "_chest"));
        return ForgeRegistries.ITEMS.containsKey(check);
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }

    public NonNullList<Ingredient> func_192400_c() {
        if (this.ingredients == null) {
            NonNullList list = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
            Ingredient ingr = Ingredient.func_199805_a((ITag)ItemTags.field_199905_b);
            for (int i = 0; i < 8; ++i) {
                list.set(i < 4 ? i : i + 1, (Object)ingr);
            }
            this.ingredients = list;
        }
        return this.ingredients;
    }

    public boolean func_192399_d() {
        return true;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MixedChestRecipe> {
        public Serializer() {
            this.setRegistryName("quark:mixed_chest");
        }

        public MixedChestRecipe read(ResourceLocation arg0, JsonObject arg1) {
            return new MixedChestRecipe(arg0);
        }

        public MixedChestRecipe read(ResourceLocation arg0, PacketBuffer arg1) {
            return new MixedChestRecipe(arg0);
        }

        public void write(PacketBuffer arg0, MixedChestRecipe arg1) {
        }
    }
}

