/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkFlammableBlock;
import vazkii.quark.base.block.QuarkFlammablePillarBlock;
import vazkii.quark.base.block.QuarkPillarBlock;
import vazkii.quark.base.handler.FuelHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.block.BurnForeverBlock;

@LoadModule(category=ModuleCategory.BUILDING)
public class CompressedBlocksModule
extends QuarkModule {
    @Config(name="Charcoal Block and Blaze Lantern Stay On Fire Forever")
    public static boolean burnsForever = true;
    @Config(name="Charcoal Block Fuel Time")
    @Config.Min(value=0.0)
    public static int charcoalBlockFuelTime = 16000;
    @Config(name="Blaze Lantern Fuel Time")
    @Config.Min(value=0.0)
    public static int blazeLanternFuelTime = 24000;
    @Config(name="Stick Block Fuel Time")
    @Config.Min(value=0.0)
    public static int stickBlockFuelTime = 900;
    @Config(flag="charcoal_block")
    public static boolean enableCharcoalBlock = true;
    @Config(flag="sugar_cane_block")
    public static boolean enableSugarCaneBlock = true;
    @Config(flag="bamboo_block")
    public static boolean enableBambooBlock = true;
    @Config(flag="cactus_block")
    public static boolean enableCactusBlock = true;
    @Config(flag="chorus_fruit_block")
    public static boolean enableChorusFruitBlock = true;
    @Config(flag="stick_block")
    public static boolean enableStickBlock = true;
    @Config(flag="apple_crate")
    public static boolean enableAppleCrate = true;
    @Config(flag="golden_apple_crate")
    public static boolean enableGoldenAppleCrate = true;
    @Config(flag="potato_crate")
    public static boolean enablePotatoCrate = true;
    @Config(flag="carrot_crate")
    public static boolean enableCarrotCrate = true;
    @Config(flag="beetroot_crate")
    public static boolean enableBeetrootCrate = true;
    @Config(flag="cocoa_beans_sack")
    public static boolean enableCocoaBeanSack = true;
    @Config(flag="nether_wart_sack")
    public static boolean enableNetherWartSack = true;
    @Config(flag="gunpowder_sack")
    public static boolean enableGunpowderSack = true;
    @Config(flag="berry_sack")
    public static boolean enableBerrySack = true;
    @Config(flag="blaze_lantern")
    public static boolean enableBlazeLantern = true;
    @Config(flag="bonded_leather")
    public static boolean enableBondedLeather = true;
    @Config(flag="bonded_rabbit_hide")
    public static boolean enableBondedRabbitHide = true;
    public static Block charcoal_block;
    public static Block stick_block;
    public static Block blaze_lantern;
    private final List<Block> compostable = Lists.newArrayList();

    @Override
    public void construct() {
        charcoal_block = new BurnForeverBlock("charcoal_block", this, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185851_d), true).setCondition(() -> enableCharcoalBlock);
        this.pillar("sugar_cane", MaterialColor.field_151672_u, true, () -> enableSugarCaneBlock, 200);
        this.pillar("bamboo", MaterialColor.field_151673_t, true, () -> enableBambooBlock, 200);
        this.pillar("cactus", MaterialColor.field_151651_C, true, () -> enableCactusBlock, 50);
        this.pillar("chorus_fruit", MaterialColor.field_151678_z, false, () -> enableChorusFruitBlock, 10);
        stick_block = this.pillar("stick", MaterialColor.field_151663_o, false, () -> enableStickBlock, 300);
        this.crate("golden_apple", MaterialColor.field_151647_F, true, () -> enableGoldenAppleCrate);
        this.crate("apple", MaterialColor.field_151645_D, true, () -> enableAppleCrate);
        this.crate("potato", MaterialColor.field_151676_q, true, () -> enablePotatoCrate);
        this.crate("carrot", MaterialColor.field_193562_N, true, () -> enableCarrotCrate);
        this.crate("beetroot", MaterialColor.field_151645_D, true, () -> enableBeetrootCrate);
        this.sack("cocoa_beans", MaterialColor.field_151650_B, true, () -> enableCocoaBeanSack);
        this.sack("nether_wart", MaterialColor.field_151645_D, true, () -> enableNetherWartSack);
        this.sack("gunpowder", MaterialColor.field_151670_w, false, () -> enableGunpowderSack);
        this.sack("berry", MaterialColor.field_151645_D, true, () -> enableBerrySack);
        blaze_lantern = new BurnForeverBlock("blaze_lantern", this, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200952_a((Material)Material.field_151592_s, (DyeColor)DyeColor.YELLOW).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_235838_a_(b -> 15), false).setCondition(() -> enableBlazeLantern);
        new QuarkBlock("bonded_leather", this, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200952_a((Material)Material.field_151580_n, (DyeColor)DyeColor.ORANGE).func_200943_b(0.4f).func_200947_a(SoundType.field_185854_g)).setCondition(() -> enableBondedLeather);
        new QuarkBlock("bonded_rabbit_hide", this, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200952_a((Material)Material.field_151580_n, (DyeColor)DyeColor.WHITE).func_200943_b(0.4f).func_200947_a(SoundType.field_185854_g)).setCondition(() -> enableBondedRabbitHide);
    }

    @Override
    public void loadComplete() {
        this.enqueue(() -> {
            for (Block block : this.compostable) {
                if (block.func_199767_j() == null) continue;
                ComposterBlock.field_220299_b.put((Object)block.func_199767_j(), 1.0f);
            }
        });
        FuelHandler.addFuel(stick_block, stickBlockFuelTime);
        FuelHandler.addFuel(charcoal_block, charcoalBlockFuelTime);
        FuelHandler.addFuel(blaze_lantern, blazeLanternFuelTime);
    }

    private Block pillar(String name, MaterialColor color, boolean compost, BooleanSupplier cond, int flammability) {
        QuarkPillarBlock block = new QuarkFlammablePillarBlock(name + "_block", this, ItemGroup.field_78030_b, flammability, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)).setCondition(cond);
        if (compost) {
            this.compostable.add((Block)block);
        }
        return block;
    }

    private Block crate(String name, MaterialColor color, boolean compost, BooleanSupplier cond) {
        QuarkBlock block = new QuarkFlammableBlock(name + "_crate", this, ItemGroup.field_78031_c, 150, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)).setCondition(cond);
        if (compost) {
            this.compostable.add((Block)block);
        }
        return block;
    }

    private Block sack(String name, MaterialColor color, boolean compost, BooleanSupplier cond) {
        QuarkBlock block = new QuarkFlammableBlock(name + "_sack", this, ItemGroup.field_78031_c, 150, AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)color).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g)).setCondition(cond);
        if (compost) {
            this.compostable.add((Block)block);
        }
        return block;
    }
}

