/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import vazkii.quark.content.building.module.RopeModule;

public class RopeBlock
extends QuarkBlock
implements IBlockItemProvider {
    private static final VoxelShape SHAPE = RopeBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public RopeBlock(String regname, QuarkModule module, ItemGroup creativeTab, AbstractBlock.Properties properties) {
        super(regname, module, creativeTab, properties);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public BlockItem provideItemBlock(Block block, Item.Properties properties) {
        return new BlockItem(block, properties){

            public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
                return world.func_180495_p(pos).func_177230_c() instanceof RopeBlock;
            }
        };
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.MAIN_HAND) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() == this.func_199767_j() && !player.func_226273_bm_()) {
                if (this.pullDown(worldIn, pos)) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    worldIn.func_184133_a(null, pos, this.field_149762_H.func_185841_e(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                    return FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)worldIn, (BlockPos)this.getBottomPos(worldIn, pos), (Direction)Direction.UP) ? ActionResultType.SUCCESS : ActionResultType.PASS;
                }
                if (stack.func_77973_b() == Items.field_151069_bo) {
                    BlockPos bottomPos = this.getBottomPos(worldIn, pos);
                    BlockState stateAt = worldIn.func_180495_p(bottomPos);
                    if (stateAt.func_185904_a() == Material.field_151586_h) {
                        Vector3d playerPos = player.func_213303_ch();
                        worldIn.func_184148_a(player, playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        ItemStack bottleStack = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
                        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
                        if (stack.func_190926_b()) {
                            player.func_184611_a(hand, bottleStack);
                        } else if (!player.field_71071_by.func_70441_a(bottleStack)) {
                            player.func_71019_a(bottleStack, false);
                        }
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.PASS;
                }
                if (this.pullUp(worldIn, pos)) {
                    if (!player.func_184812_l_() && !player.func_191521_c(new ItemStack((IItemProvider)this))) {
                        player.func_71019_a(new ItemStack((IItemProvider)this), false);
                    }
                    worldIn.func_184133_a(null, pos, this.field_149762_H.func_185845_c(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.PASS;
    }

    public boolean pullUp(World world, BlockPos pos) {
        BlockState state;
        BlockPos basePos = pos;
        while ((state = world.func_180495_p(pos = pos.func_177977_b())).func_177230_c() == this) {
        }
        BlockPos ropePos = pos.func_177984_a();
        if (ropePos.equals((Object)basePos)) {
            return false;
        }
        world.func_175656_a(ropePos, Blocks.field_150350_a.func_176223_P());
        this.moveBlock(world, pos, ropePos);
        return true;
    }

    public boolean pullDown(World world, BlockPos pos) {
        BlockState state;
        boolean endRope = false;
        boolean wasAirAtEnd = false;
        while (true) {
            if (!World.func_175701_a((BlockPos)(pos = pos.func_177977_b()))) {
                return false;
            }
            state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block == this) continue;
            if (endRope) break;
            endRope = true;
            wasAirAtEnd = world.func_175623_d(pos);
        }
        boolean can = wasAirAtEnd || world.func_175623_d(pos) || state.func_185904_a().func_76222_j();
        if (can) {
            BlockPos ropePos = pos.func_177984_a();
            this.moveBlock(world, ropePos, pos);
            BlockState ropePosState = world.func_180495_p(ropePos);
            if (world.func_175623_d(ropePos) || ropePosState.func_185904_a().func_76222_j()) {
                world.func_175656_a(ropePos, this.func_176223_P());
                return true;
            }
        }
        return false;
    }

    private BlockPos getBottomPos(World worldIn, BlockPos pos) {
        RopeBlock block = this;
        while (block == this) {
            pos = pos.func_177977_b();
            BlockState state = worldIn.func_180495_p(pos);
            block = state.func_177230_c();
        }
        return pos;
    }

    private void moveBlock(World world, BlockPos srcPos, BlockPos dstPos) {
        BlockState state = world.func_180495_p(srcPos);
        Block block = state.func_177230_c();
        if (state.func_185887_b((IBlockReader)world, srcPos) == -1.0f || !state.func_196955_c((IWorldReader)world, dstPos) || block.isAir(state, (IBlockReader)world, srcPos) || state.func_185905_o() != PushReaction.NORMAL || block == Blocks.field_150343_Z) {
            return;
        }
        TileEntity tile = world.func_175625_s(srcPos);
        if (tile != null) {
            if (RopeModule.forceEnableMoveTileEntities ? PistonsMoveTileEntitiesModule.shouldMoveTE(state) : PistonsMoveTileEntitiesModule.shouldMoveTE(true, state)) {
                return;
            }
            tile.func_145843_s();
        }
        world.func_175656_a(srcPos, Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(dstPos, state);
        if (tile != null) {
            tile.func_174878_a(dstPos);
            TileEntity target = TileEntity.func_235657_b_((BlockState)state, (CompoundNBT)tile.func_189515_b(new CompoundNBT()));
            if (target != null) {
                world.func_175690_a(dstPos, target);
                target.func_145836_u();
            }
        }
        world.func_195593_d(dstPos, state.func_177230_c());
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos upPos = pos.func_177984_a();
        BlockState upState = worldIn.func_180495_p(upPos);
        return upState.func_177230_c() == this || upState.func_224755_d((IBlockReader)worldIn, upPos, Direction.DOWN);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)worldIn.func_180495_p(pos)));
            RopeBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 30;
    }

    @Override
    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }
}

