/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.world.ChunkCornerPlacement;
import vazkii.quark.base.world.ConditionalConfiguredFeature;
import vazkii.quark.base.world.DeferedFeature;
import vazkii.quark.base.world.WeightedGenerator;
import vazkii.quark.base.world.generator.IGenerator;

@Mod.EventBusSubscriber(modid="quark")
public class WorldGenHandler {
    private static Map<GenerationStage.Decoration, Feature<NoFeatureConfig>> defersBaseFeature = new HashMap<GenerationStage.Decoration, Feature<NoFeatureConfig>>();
    private static Map<GenerationStage.Decoration, Supplier<ConfiguredFeature<?, ?>>> defers = new HashMap();
    private static Map<GenerationStage.Decoration, SortedSet<WeightedGenerator>> generators = new HashMap<GenerationStage.Decoration, SortedSet<WeightedGenerator>>();
    private static Map<GenerationStage.Decoration, List<Pair<BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig>, BooleanSupplier>>> featureConditionalizers = new HashMap<GenerationStage.Decoration, List<Pair<BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig>, BooleanSupplier>>>();
    private static Map<String, Pair<GenerationStage.Decoration, ConditionalConfiguredFeature<?, ?>>> featureReplacers = new HashMap();
    public static Placement<NoPlacementConfig> CHUNK_CORNER_PLACEMENT = new ChunkCornerPlacement();

    public static void register() {
        WorldGenHandler.registerPlacements();
        WorldGenHandler.registerFeatures();
    }

    private static void registerPlacements() {
        CHUNK_CORNER_PLACEMENT.setRegistryName("quark", "chunk_corner_placement");
        RegistryHelper.register(CHUNK_CORNER_PLACEMENT);
    }

    private static void registerFeatures() {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            DeferedFeature deferredFeature = new DeferedFeature(stage);
            deferredFeature.setRegistryName("quark", "deferred_feature_" + stage.name().toLowerCase(Locale.ENGLISH));
            RegistryHelper.register((IForgeRegistryEntry)deferredFeature);
            defersBaseFeature.put(stage, deferredFeature);
        }
    }

    public static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
                ConfiguredFeature feature = defersBaseFeature.get(stage).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(CHUNK_CORNER_PLACEMENT.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_202468_e));
                Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("quark", "deferred_feature_" + stage.name().toLowerCase(Locale.ENGLISH)), (Object)feature);
                defers.put(stage, () -> feature);
            }
            WorldGenHandler.setupConditionalizers();
        });
    }

    public static void setupConditionalizers() {
        HashSet quarkCfsToRegister = new HashSet();
        for (Map.Entry cfEntry : WorldGenRegistries.field_243653_e.func_239659_c_()) {
            ConfiguredFeature configuredFeature = (ConfiguredFeature)cfEntry.getValue();
            Feature feature = configuredFeature.field_222737_a;
            IFeatureConfig config = configuredFeature.field_222738_b;
            while (config instanceof DecoratedFeatureConfig) {
                DecoratedFeatureConfig dconfig = (DecoratedFeatureConfig)config;
                feature = ((ConfiguredFeature)dconfig.field_214689_a.get()).field_222737_a;
                config = ((ConfiguredFeature)dconfig.field_214689_a.get()).field_222738_b;
            }
            for (Map.Entry<GenerationStage.Decoration, List<Pair<BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig>, BooleanSupplier>>> conditionalizerEntry : featureConditionalizers.entrySet()) {
                for (Pair<BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig>, BooleanSupplier> pair : conditionalizerEntry.getValue()) {
                    if (!((BiPredicate)pair.getLeft()).test(feature, config)) continue;
                    ConditionalConfiguredFeature conditionalConfiguredFeature = new ConditionalConfiguredFeature(configuredFeature, (BooleanSupplier)pair.getRight());
                    quarkCfsToRegister.add(conditionalConfiguredFeature);
                    Optional tempOptional = ConfiguredFeature.field_242763_a.encode((Object)configuredFeature, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
                    String cfJSON = tempOptional.isPresent() ? ((JsonElement)tempOptional.get()).toString() : "";
                    featureReplacers.put(cfJSON, Pair.of((Object)conditionalizerEntry.getKey(), conditionalConfiguredFeature));
                }
            }
        }
        int cfIdOffset = 1;
        for (ConfiguredFeature configuredFeature : quarkCfsToRegister) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("quark", "conditional_configured_feature_" + cfIdOffset), (Object)configuredFeature);
            ++cfIdOffset;
        }
    }

    @SubscribeEvent
    public static void onBiomesLoaded(BiomeLoadingEvent ev) {
        BiomeGenerationSettingsBuilder settings = ev.getGeneration();
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            List features = settings.getFeatures(stage);
            features.add(defers.get(stage));
            if (!featureConditionalizers.containsKey(stage)) continue;
            for (int i = 0; i < features.size(); ++i) {
                String cfTargetJSON;
                ConfiguredFeature configuredFeature = (ConfiguredFeature)((Supplier)features.get(i)).get();
                Optional tempOptional = ConfiguredFeature.field_242763_a.encode((Object)configuredFeature, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
                String string = cfTargetJSON = tempOptional.isPresent() ? ((JsonElement)tempOptional.get()).toString() : "";
                if (!featureReplacers.containsKey(cfTargetJSON) || featureReplacers.get(cfTargetJSON).getLeft() != stage) continue;
                features.set(i, () -> (ConditionalConfiguredFeature)((Object)((Object)featureReplacers.get(cfTargetJSON).getRight())));
            }
        }
    }

    public static void addGenerator(QuarkModule module, IGenerator generator, GenerationStage.Decoration stage, int weight) {
        WeightedGenerator weighted = new WeightedGenerator(module, generator, weight);
        if (!generators.containsKey(stage)) {
            generators.put(stage, new TreeSet());
        }
        generators.get(stage).add(weighted);
    }

    public static void conditionalizeFeatures(GenerationStage.Decoration stage, BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig> pred, BooleanSupplier condition) {
        if (!featureConditionalizers.containsKey(stage)) {
            featureConditionalizers.put(stage, new LinkedList());
        }
        List<Pair<BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig>, BooleanSupplier>> list = featureConditionalizers.get(stage);
        list.add((Pair<BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig>, BooleanSupplier>)Pair.of(pred, (Object)condition));
    }

    public static void generateChunk(ISeedReader seedReader, ChunkGenerator generator, BlockPos pos, GenerationStage.Decoration stage) {
        if (!(seedReader instanceof WorldGenRegion)) {
            return;
        }
        WorldGenRegion region = (WorldGenRegion)seedReader;
        SharedSeedRandom random = new SharedSeedRandom();
        long seed = random.func_202424_a(region.func_72905_C(), region.func_201679_a() * 16, region.func_201680_b() * 16);
        int stageNum = stage.ordinal() * 10000;
        if (generators.containsKey(stage)) {
            SortedSet<WeightedGenerator> set = generators.get(stage);
            for (WeightedGenerator wgen : set) {
                IGenerator gen = wgen.generator;
                if (!wgen.module.enabled || !gen.canGenerate((IServerWorld)region)) continue;
                if (GeneralConfig.enableWorldgenWatchdog) {
                    int finalStageNum = stageNum;
                    stageNum = WorldGenHandler.watchdogRun(gen, () -> gen.generate(finalStageNum, seed, stage, region, generator, random, pos), 1, TimeUnit.MINUTES);
                    continue;
                }
                stageNum = gen.generate(stageNum, seed, stage, region, generator, random, pos);
            }
        }
    }

    private static int watchdogRun(IGenerator gen, Callable<Integer> run, int time, TimeUnit unit) {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Integer> future = exec.submit(run);
        exec.shutdown();
        try {
            return future.get(time, unit);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating " + gen, e);
        }
    }
}

