/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MinecartItem;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.quark.addons.oddities.container.BackpackContainer;
import vazkii.quark.addons.oddities.container.SlotCachingItemHandler;
import vazkii.quark.api.ICustomSorting;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.management.module.InventorySortingModule;

public final class SortingHandler {
    private static final Comparator<ItemStack> FALLBACK_COMPARATOR = SortingHandler.jointComparator(Comparator.comparingInt(s -> Item.func_150891_b((Item)s.func_77973_b())), SortingHandler::damageCompare, (s1, s2) -> s2.func_190916_E() - s1.func_190916_E(), (s1, s2) -> s2.hashCode() - s1.hashCode());
    private static final Comparator<ItemStack> FOOD_COMPARATOR = SortingHandler.jointComparator(SortingHandler::foodHealCompare, SortingHandler::foodSaturationCompare);
    private static final Comparator<ItemStack> TOOL_COMPARATOR = SortingHandler.jointComparator(SortingHandler::toolPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> SWORD_COMPARATOR = SortingHandler.jointComparator(SortingHandler::swordPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> ARMOR_COMPARATOR = SortingHandler.jointComparator(SortingHandler::armorSlotAndToughnessCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> BOW_COMPARATOR = SortingHandler.jointComparator(SortingHandler::enchantmentCompare, SortingHandler::damageCompare);

    public static void sortInventory(PlayerEntity player, boolean forcePlayer) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(InventorySortingModule.class)) {
            return;
        }
        Container c = player.field_71070_bA;
        boolean backpack = c instanceof BackpackContainer;
        if (!backpack && forcePlayer || c == null) {
            c = player.field_71069_bz;
        }
        boolean playerContainer = c == player.field_71069_bz || backpack;
        for (Slot s : c.field_75151_b) {
            IInventory inv = s.field_75224_c;
            if (inv == player.field_71071_by != playerContainer) continue;
            if (!playerContainer && s instanceof SlotItemHandler) {
                SortingHandler.sortInventory(((SlotItemHandler)s).getItemHandler());
                break;
            }
            InvWrapper wrapper = new InvWrapper(inv);
            if (playerContainer) {
                SortingHandler.sortInventory((IItemHandler)wrapper, 9, 36);
                break;
            }
            SortingHandler.sortInventory((IItemHandler)wrapper);
            break;
        }
        if (backpack) {
            for (Slot s : c.field_75151_b) {
                if (!(s instanceof SlotCachingItemHandler)) continue;
                SortingHandler.sortInventory(((SlotCachingItemHandler)s).getItemHandler());
                break;
            }
        }
    }

    public static void sortInventory(IItemHandler handler) {
        SortingHandler.sortInventory(handler, 0);
    }

    public static void sortInventory(IItemHandler handler, int iStart) {
        SortingHandler.sortInventory(handler, iStart, handler.getSlots());
    }

    public static void sortInventory(IItemHandler handler, int iStart, int iEnd) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> restore = new ArrayList<ItemStack>();
        for (int i = iStart; i < iEnd; ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            restore.add(stackAt.func_77946_l());
            if (stackAt.func_190926_b()) continue;
            stacks.add(stackAt.func_77946_l());
        }
        SortingHandler.mergeStacks(stacks);
        SortingHandler.sortStackList(stacks);
        if (SortingHandler.setInventory(handler, stacks, iStart, iEnd) == ActionResultType.FAIL) {
            SortingHandler.setInventory(handler, restore, iStart, iEnd);
        }
    }

    private static ActionResultType setInventory(IItemHandler inventory, List<ItemStack> stacks, int iStart, int iEnd) {
        ItemStack stack;
        int j;
        int i;
        for (i = iStart; i < iEnd; ++i) {
            j = i - iStart;
            ItemStack itemStack = stack = j >= stacks.size() ? ItemStack.field_190927_a : stacks.get(j);
            if (stack.func_190926_b() || inventory.isItemValid(i, stack)) continue;
            return ActionResultType.PASS;
        }
        for (i = iStart; i < iEnd; ++i) {
            j = i - iStart;
            stack = j >= stacks.size() ? ItemStack.field_190927_a : stacks.get(j);
            inventory.extractItem(i, inventory.getSlotLimit(i), false);
            if (stack.func_190926_b() || inventory.insertItem(i, stack, false).func_190926_b()) continue;
            return ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    private static void mergeStacks(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack set = SortingHandler.mergeStackWithOthers(list, i);
            list.set(i, set);
        }
        list.removeIf(stack -> stack.func_190926_b() || stack.func_190916_E() == 0);
    }

    private static ItemStack mergeStackWithOthers(List<ItemStack> list, int index) {
        ItemStack stack = list.get(index);
        if (stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stackAt;
            if (i == index || (stackAt = list.get(i)).func_190926_b() || stackAt.func_190916_E() >= stackAt.func_77976_d() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stackAt) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackAt)) continue;
            int setSize = stackAt.func_190916_E() + stack.func_190916_E();
            int carryover = Math.max(0, setSize - stackAt.func_77976_d());
            stackAt.func_190920_e(carryover);
            stack.func_190920_e(setSize - carryover);
            if (stack.func_190916_E() != stack.func_77976_d()) continue;
            return stack;
        }
        return stack;
    }

    public static void sortStackList(List<ItemStack> list) {
        list.sort(SortingHandler::stackCompare);
    }

    private static int stackCompare(ItemStack stack1, ItemStack stack2) {
        ItemType type2;
        ItemType type1;
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1.func_190926_b()) {
            return -1;
        }
        if (stack2.func_190926_b()) {
            return 1;
        }
        if (SortingHandler.hasCustomSorting(stack1) && SortingHandler.hasCustomSorting(stack2)) {
            ICustomSorting sort1 = SortingHandler.getCustomSorting(stack1);
            ICustomSorting sort2 = SortingHandler.getCustomSorting(stack2);
            if (sort1.getSortingCategory().equals(sort2.getSortingCategory())) {
                return sort1.getItemComparator().compare(stack1, stack2);
            }
        }
        if ((type1 = SortingHandler.getType(stack1)) == (type2 = SortingHandler.getType(stack2))) {
            return type1.comparator.compare(stack1, stack2);
        }
        return type1.ordinal() - type2.ordinal();
    }

    private static ItemType getType(ItemStack stack) {
        for (ItemType type : ItemType.values()) {
            if (!type.fitsInType(stack)) continue;
            return type;
        }
        throw new RuntimeException("Having an ItemStack that doesn't fit in any type is impossible.");
    }

    private static Predicate<ItemStack> classPredicate(Class<? extends Item> clazz) {
        return s -> !s.func_190926_b() && clazz.isInstance(s.func_77973_b());
    }

    private static Predicate<ItemStack> inverseClassPredicate(Class<? extends Item> clazz) {
        return SortingHandler.classPredicate(clazz).negate();
    }

    private static Predicate<ItemStack> itemPredicate(List<Item> list) {
        return s -> !s.func_190926_b() && list.contains(s.func_77973_b());
    }

    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> finalComparator, Comparator<ItemStack>[] otherComparators) {
        if (otherComparators == null) {
            return SortingHandler.jointComparator(finalComparator);
        }
        Comparator<ItemStack>[] resizedArray = Arrays.copyOf(otherComparators, otherComparators.length + 1);
        resizedArray[otherComparators.length] = finalComparator;
        return SortingHandler.jointComparator(resizedArray);
    }

    @SafeVarargs
    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> ... comparators) {
        return SortingHandler.jointComparatorFallback((s1, s2) -> {
            for (Comparator comparator : comparators) {
                int compare;
                if (comparator == null || (compare = comparator.compare(s1, s2)) == 0) continue;
                return compare;
            }
            return 0;
        }, FALLBACK_COMPARATOR);
    }

    private static Comparator<ItemStack> jointComparatorFallback(Comparator<ItemStack> comparator, Comparator<ItemStack> fallback) {
        return (s1, s2) -> {
            int compare = comparator.compare((ItemStack)s1, (ItemStack)s2);
            if (compare == 0) {
                return fallback == null ? 0 : fallback.compare((ItemStack)s1, (ItemStack)s2);
            }
            return compare;
        };
    }

    private static Comparator<ItemStack> listOrderComparator(List<Item> list) {
        return (stack1, stack2) -> {
            Item i1 = stack1.func_77973_b();
            Item i2 = stack2.func_77973_b();
            if (list.contains(i1)) {
                if (list.contains(i2)) {
                    return list.indexOf(i1) - list.indexOf(i2);
                }
                return 1;
            }
            if (list.contains(i2)) {
                return -1;
            }
            return 0;
        };
    }

    private static List<Item> list(Object ... items) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (Object o : items) {
            if (o == null) continue;
            if (o instanceof Item) {
                itemList.add((Item)o);
                continue;
            }
            if (o instanceof Block) {
                itemList.add(((Block)o).func_199767_j());
                continue;
            }
            if (o instanceof ItemStack) {
                itemList.add(((ItemStack)o).func_77973_b());
                continue;
            }
            if (!(o instanceof String)) continue;
            Registry.field_212630_s.func_241873_b(new ResourceLocation((String)o)).ifPresent(itemList::add);
        }
        return itemList;
    }

    private static int foodHealCompare(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b().func_219967_s().func_221466_a() - stack1.func_77973_b().func_219967_s().func_221466_a();
    }

    private static int foodSaturationCompare(ItemStack stack1, ItemStack stack2) {
        return (int)(stack2.func_77973_b().func_219967_s().func_221469_b() * 100.0f - stack1.func_77973_b().func_219967_s().func_221469_b() * 100.0f);
    }

    private static int enchantmentCompare(ItemStack stack1, ItemStack stack2) {
        return SortingHandler.enchantmentPower(stack2) - SortingHandler.enchantmentPower(stack1);
    }

    private static int enchantmentPower(ItemStack stack) {
        if (!stack.func_77948_v()) {
            return 0;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int total = 0;
        for (Integer i : enchantments.values()) {
            total += i.intValue();
        }
        return total;
    }

    private static int toolPowerCompare(ItemStack stack1, ItemStack stack2) {
        IItemTier mat1 = ((ToolItem)stack1.func_77973_b()).func_200891_e();
        IItemTier mat2 = ((ToolItem)stack2.func_77973_b()).func_200891_e();
        return (int)(mat2.func_200928_b() * 100.0f - mat1.func_200928_b() * 100.0f);
    }

    private static int swordPowerCompare(ItemStack stack1, ItemStack stack2) {
        IItemTier mat1 = ((SwordItem)stack1.func_77973_b()).func_200891_e();
        IItemTier mat2 = ((SwordItem)stack2.func_77973_b()).func_200891_e();
        return (int)(mat2.func_200929_c() * 100.0f - mat1.func_200929_c() * 100.0f);
    }

    private static int armorSlotAndToughnessCompare(ItemStack stack1, ItemStack stack2) {
        EquipmentSlotType slot2;
        ArmorItem armor1 = (ArmorItem)stack1.func_77973_b();
        ArmorItem armor2 = (ArmorItem)stack2.func_77973_b();
        EquipmentSlotType slot1 = armor1.func_185083_B_();
        if (slot1 == (slot2 = armor2.func_185083_B_())) {
            return armor2.func_200880_d().func_200902_b(slot2) - armor2.func_200880_d().func_200902_b(slot1);
        }
        return slot2.func_188454_b() - slot1.func_188454_b();
    }

    public static int damageCompare(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77952_i() - stack2.func_77952_i();
    }

    static boolean hasCustomSorting(ItemStack stack) {
        return stack.getCapability(QuarkCapabilities.SORTING, null).isPresent();
    }

    static ICustomSorting getCustomSorting(ItemStack stack) {
        return (ICustomSorting)stack.getCapability(QuarkCapabilities.SORTING, null).orElse(null);
    }

    static /* synthetic */ Comparator access$100() {
        return FOOD_COMPARATOR;
    }

    static /* synthetic */ List access$200(Object[] x0) {
        return SortingHandler.list(x0);
    }

    static /* synthetic */ Predicate access$300(Class x0) {
        return SortingHandler.classPredicate(x0);
    }

    static /* synthetic */ Comparator access$400() {
        return TOOL_COMPARATOR;
    }

    static /* synthetic */ Comparator access$500() {
        return SWORD_COMPARATOR;
    }

    static /* synthetic */ Comparator access$600() {
        return ARMOR_COMPARATOR;
    }

    static /* synthetic */ Comparator access$700() {
        return BOW_COMPARATOR;
    }

    static /* synthetic */ Predicate access$800(Class x0) {
        return SortingHandler.inverseClassPredicate(x0);
    }

    private static enum ItemType {
        FOOD(ItemStack::func_222117_E, (Comparator<ItemStack>)SortingHandler.access$100()),
        TORCH(SortingHandler.access$200(new Object[]{Blocks.field_150478_aa}), new Comparator[0]),
        TOOL_PICKAXE(SortingHandler.access$300(PickaxeItem.class), (Comparator<ItemStack>)SortingHandler.access$400()),
        TOOL_SHOVEL(SortingHandler.access$300(ShovelItem.class), (Comparator<ItemStack>)SortingHandler.access$400()),
        TOOL_AXE(SortingHandler.access$300(AxeItem.class), (Comparator<ItemStack>)SortingHandler.access$400()),
        TOOL_SWORD(SortingHandler.access$300(SwordItem.class), (Comparator<ItemStack>)SortingHandler.access$500()),
        TOOL_GENERIC(SortingHandler.access$300(ToolItem.class), (Comparator<ItemStack>)SortingHandler.access$400()),
        ARMOR(SortingHandler.access$300(ArmorItem.class), (Comparator<ItemStack>)SortingHandler.access$600()),
        BOW(SortingHandler.access$300(BowItem.class), (Comparator<ItemStack>)SortingHandler.access$700()),
        CROSSBOW(SortingHandler.access$300(CrossbowItem.class), (Comparator<ItemStack>)SortingHandler.access$700()),
        TRIDENT(SortingHandler.access$300(TridentItem.class), (Comparator<ItemStack>)SortingHandler.access$700()),
        ARROWS(SortingHandler.access$300(ArrowItem.class)),
        POTION(SortingHandler.access$300(PotionItem.class)),
        MINECART(SortingHandler.access$300(MinecartItem.class)),
        RAIL(SortingHandler.access$200(new Object[]{Blocks.field_150448_aq, Blocks.field_196552_aC, Blocks.field_150319_E, Blocks.field_150408_cc}), new Comparator[0]),
        DYE(SortingHandler.access$300(DyeItem.class)),
        ANY(SortingHandler.access$800(BlockItem.class)),
        BLOCK(SortingHandler.access$300(BlockItem.class));

        private final Predicate<ItemStack> predicate;
        private final Comparator<ItemStack> comparator;

        @SafeVarargs
        private ItemType(List<Item> list, Comparator<ItemStack> ... comparators) {
            this(SortingHandler.itemPredicate(list), SortingHandler.jointComparator((Comparator<ItemStack>)SortingHandler.listOrderComparator(list), comparators));
        }

        private ItemType(Predicate<ItemStack> predicate) {
            this(predicate, (Comparator<ItemStack>)FALLBACK_COMPARATOR);
        }

        private ItemType(Predicate<ItemStack> predicate, Comparator<ItemStack> comparator) {
            this.predicate = predicate;
            this.comparator = comparator;
        }

        public boolean fitsInType(ItemStack stack) {
            return this.predicate.test(stack);
        }
    }
}

