/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.recipe.FlagIngredient;
import vazkii.quark.base.util.PotionReflection;

public class BrewingHandler {
    private static boolean isInjectionPrepared = false;
    private static final List<Triple<Potion, Supplier<Ingredient>, Potion>> toRegister = Lists.newArrayList();

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, Effect effect) {
        BrewingHandler.addPotionMix(flag, reagent, effect, null);
    }

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, Effect effect, int normalTime, int longTime, int strongTime) {
        BrewingHandler.addPotionMix(flag, reagent, effect, null, normalTime, longTime, strongTime);
    }

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, Effect effect, @Nullable Effect negation) {
        BrewingHandler.addPotionMix(flag, reagent, effect, negation, 3600, 9600, 1800);
    }

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, Effect effect, @Nullable Effect negation, int normalTime, int longTime, int strongTime) {
        ResourceLocation loc = effect.getRegistryName();
        if (loc != null) {
            ResourceLocation negationLoc;
            String baseName = loc.func_110623_a();
            boolean hasStrong = strongTime > 0;
            Potion normalType = BrewingHandler.addPotion(new EffectInstance(effect, normalTime), baseName, baseName);
            Potion longType = BrewingHandler.addPotion(new EffectInstance(effect, longTime), baseName, "long_" + baseName);
            Potion strongType = !hasStrong ? null : BrewingHandler.addPotion(new EffectInstance(effect, strongTime, 1), baseName, "strong_" + baseName);
            BrewingHandler.addPotionMix(flag, reagent, normalType, longType, strongType);
            if (negation != null && (negationLoc = negation.getRegistryName()) != null) {
                String negationBaseName = negationLoc.func_110623_a();
                Potion normalNegationType = BrewingHandler.addPotion(new EffectInstance(negation, normalTime), negationBaseName, negationBaseName);
                Potion longNegationType = BrewingHandler.addPotion(new EffectInstance(negation, longTime), negationBaseName, "long_" + negationBaseName);
                Potion strongNegationType = !hasStrong ? null : BrewingHandler.addPotion(new EffectInstance(negation, strongTime, 1), negationBaseName, "strong_" + negationBaseName);
                BrewingHandler.addNegation(flag, normalType, longType, strongType, normalNegationType, longNegationType, strongNegationType);
            }
        }
    }

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, Potion normalType, Potion longType, @Nullable Potion strongType) {
        boolean hasStrong = strongType != null;
        BrewingHandler.add(flag, Potions.field_185233_e, reagent, normalType);
        BrewingHandler.add(flag, Potions.field_185230_b, reagent, Potions.field_185231_c);
        if (hasStrong) {
            BrewingHandler.add(flag, normalType, BrewingHandler::glowstone, strongType);
        }
        BrewingHandler.add(flag, normalType, BrewingHandler::redstone, longType);
    }

    public static void addNegation(String flag, Potion normalType, Potion longType, @Nullable Potion strongType, Potion normalNegatedType, Potion longNegatedType, @Nullable Potion strongNegatedType) {
        boolean hasStrong;
        BrewingHandler.add(flag, normalType, BrewingHandler::spiderEye, normalNegatedType);
        boolean bl = hasStrong = strongType != null && strongNegatedType != null;
        if (hasStrong) {
            BrewingHandler.add(flag, strongType, BrewingHandler::spiderEye, strongNegatedType);
            BrewingHandler.add(flag, normalNegatedType, BrewingHandler::glowstone, strongNegatedType);
        }
        BrewingHandler.add(flag, longType, BrewingHandler::spiderEye, longNegatedType);
        BrewingHandler.add(flag, normalNegatedType, BrewingHandler::redstone, longNegatedType);
    }

    public static ItemStack of(Item potionType, Potion potion) {
        ItemStack stack = new ItemStack((IItemProvider)potionType);
        PotionUtils.func_185188_a((ItemStack)stack, (Potion)potion);
        return stack;
    }

    public static void setup() {
        isInjectionPrepared = true;
        for (Triple<Potion, Supplier<Ingredient>, Potion> triple : toRegister) {
            PotionReflection.addBrewingRecipe((Potion)triple.getLeft(), (Ingredient)((Supplier)triple.getMiddle()).get(), (Potion)triple.getRight());
        }
        toRegister.clear();
    }

    private static void add(String flag, Potion potion, Supplier<Ingredient> reagent, Potion to) {
        if (isInjectionPrepared) {
            PotionReflection.addBrewingRecipe(potion, new FlagIngredient(reagent.get(), flag), to);
        } else {
            toRegister.add((Triple<Potion, Supplier<Ingredient>, Potion>)new ImmutableTriple((Object)potion, () -> new FlagIngredient((Ingredient)reagent.get(), flag), (Object)to));
        }
    }

    private static Potion addPotion(EffectInstance eff, String baseName, String name) {
        Potion effect = new Potion("quark." + baseName, new EffectInstance[]{eff});
        RegistryHelper.register((IForgeRegistryEntry)effect, (String)name);
        return effect;
    }

    private static Ingredient redstone() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax});
    }

    private static Ingredient glowstone() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151114_aO});
    }

    private static Ingredient spiderEye() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151071_bq});
    }
}

